<?php
// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: amazon.inc.php,v 1.15 2005/04/09 03:18:06 henoheno Exp $
// Id: amazon.inc.php,v 1.1 2003/07/24 13:00:00 ׼
//
// Amazon plugin: Book-review maker via amazon.com/amazon.jp
//
// Copyright:
//	2004-2005 PukiWiki Developers Team
//	2003 ׼ <raku@rakunet.org> (Original author)
//
// License: GNU/GPL
//
// ChangeLog:
// * 2004/04/03 PukiWiki Developer Team (arino <arino@users.sourceforge.jp>)
//        - replace plugin_amazon_get_page().
//        - PLUGIN_AMAZON_XML 'xml.amazon.com' -> 'xml.amazon.co.jp'
// * 0.6  URL ¸ߤʤ硢No image ɽ֤ʤɽ
//        饤ץ饰θƤӽФ
//	  ASIN ֹʬå롣
//	  ȥΥåˤ®٤åס
// * 0.7  ֥åӥ塼ΥǥХåǧΰΥꥢ
// * 0.8  amazon ʤβɽ
//	   ID б
// * 0.9  RedHat9+php4.3.2+apache2.0.46 ǲޤǤɤ߹ޤʤн衣
//        ܸڡβ˥֥åӥ塼Ȥʸƺʤβ衣
//        ҤǤʤ CD ʤɡASIN ʬĹƤ⥿ȥ򤦤ޤ褦ˤ롣
//        ̱ƤΤ߼ΤǤʤСB000002G6J.01 Ƚ񤫤 B000002G6J Ƚ񤤤Ƥ̱ƤФ褦ˤ롣
//	  ASIN б륭å/å奿ȥ򤽤줾뵡ǽɲá
//	  proxy б(Ū)
//	  proxy βǰ̥桼Τ AID ϤʤȤ⼫ư뤳Ȥ狼ꡢ
// * 1.0  ֥åӥ塼Ǥʤӥ塼Ȥ롣
//        Υå¤ߤ롣
//        ȥ롢̱Ƥ Web Services  XML ˡˤä get 뤳Ȥǻ֤ṳ̂롣
//        ӥ塼ڡΥߥ󥰤ˤĤ롣
// * 1.1  Խ¤򤫤Ƥ硢Ԥӥ塼ȤơڡϤǤʤ ASIN4774110655.tit ʤɤΥå夬ǤΤ衣
//        κǸ夬 01 ξ硢image  noimage.jpg ȤʤäƤޤХ
//        1.0 Ƴ XML Ϲ®֤󤬥ʤΤǡ09 ʤ 01 ȥ饤롢ǻŪ˲衣
//
// Caution!:
// * Ϣ١www.amazon.co.jp Υȥץǧξ头Ѳ
// * ӥ塼ϡamazon ץ饰󤬸ƤӽФԽ̤Ϥ⤦ PukiWiki ϿƤΤǡ
//   ߤʤʸƥڡιܥ򲡤ȡ
// *  PLUGIN_AMAZON_AIDPROXY Фʬexpire ʬŬԽƻѤƤ(¾ϤΤޤޤǤ Ok)
//
// Thanks to: Reimy and PukiWiki Developers Team
//

/////////////////////////////////////////////////
// Settings

// Amazon associate ID
//define('PLUGIN_AMAZON_AID',''); // None
define('PLUGIN_AMAZON_AID','');

// Expire caches per ? days
define('PLUGIN_AMAZON_EXPIRE_IMAGECACHE',   1);
define('PLUGIN_AMAZON_EXPIRE_TITLECACHE', 356);

// Alternative image for 'Image not found'
define('PLUGIN_AMAZON_NO_IMAGE', IMAGE_DIR . 'noimage.png');

// URI prefixes
switch(LANG){
case 'ja':
	// Amazon shop
	define('PLUGIN_AMAZON_SHOP_URI', 'http://www.amazon.co.jp/exec/obidos/ASIN/');

	// Amazon information inquiry (dev-t = default value in the manual)
	define('PLUGIN_AMAZON_XML', 'http://xml.amazon.co.jp/onca/xml3?t=webservices-20&' .
		'dev-t=GTYDRES564THU&type=lite&page=1&f=xml&locale=jp&AsinSearch=');
	break;
default:
	// Amazon shop
	define('PLUGIN_AMAZON_SHOP_URI', 'http://www.amazon.com/exec/obidos/ASIN/');

	// Amazon information inquiry (dev-t = default value in the manual)
	define('PLUGIN_AMAZON_XML', 'http://xml.amazon.com/onca/xml3?t=webservices-20&' .
		'dev-t=GTYDRES564THU&type=lite&page=1&f=xml&locale=us&AsinSearch=');
	break;
}

/////////////////////////////////////////////////

function plugin_amazon_init()
{
	global $amazon_aid, $amazon_body;

	if (PLUGIN_AMAZON_AID == '') {
		$amazon_aid = '';
	} else {
		$amazon_aid = PLUGIN_AMAZON_AID . '/';
	}
	$amazon_body = <<<EOD
-: [[ԽΤ]]
-ɾ: ̾
-: &date;
**о
[[ԽΤ]]

#amazon(,clear)
**
[[ԽΤ]]

// ޤΥӥ塼ߤ硢ʸڡ[ܥ]򲡤Ƥ(PukiWiki ˤϤ⤦ϿƤޤ)
// ³ʤ顢Ρ[[ԽΤ]]ʬ̤ޤƺľƤ
// ̾ʬϤʬ̾ѹƤȡ׼ˡǤ
// **оݡϡԤɲäʤǤܼ˻ѤΤǡ
// //ǻϤޤ륳ȹԤϡǽŪåȤƤܼ˺Ǥʤǽޤ
#comment
EOD;
}

function plugin_amazon_convert()
{
	global $script, $vars, $asin, $asin_all;

	if (func_num_args() > 3) {
		if (PKWK_READONLY) return ''; // Show nothing

		return '#amazon([ASIN-number][,left|,right]' .
			'[,book-title|,image|,delimage|,deltitle|,delete])';

	} else if (func_num_args() == 0) {
		// ӥ塼
		if (PKWK_READONLY) return ''; // Show nothing

		$s_page = htmlspecialchars($vars['page']);
		if ($s_page == '') $s_page = isset($vars['refer']) ? $vars['refer'] : '';
		$ret = <<<EOD
<form action="$script" method="post">
 <div>
  <input type="hidden" name="plugin" value="amazon" />
  <input type="hidden" name="refer" value="$s_page" />
  ASIN:
  <input type="text" name="asin" size="30" value="" />
  <input type="submit" value="ӥ塼Խ" /> (ISBN 10  or ASIN 12 )
 </div>
</form>
EOD;
		return $ret;
	}

	$aryargs = func_get_args();

	$align = strtolower($aryargs[1]);
	if ($align == 'clear') return '<div style="clear:both"></div>'; // 
	if ($align != 'left') $align = 'right'; // ַ

	$asin_all = htmlspecialchars($aryargs[0]);  // for XSS
	if (is_asin() == FALSE && $align != 'clear') return FALSE;

	if ($aryargs[2] != '') {
		// ȥ
		$title = $alt = htmlspecialchars($aryargs[2]); // for XSS
		if ($alt == 'image') {
			$alt = plugin_amazon_get_asin_title();
			if ($alt == '') return FALSE;
			$title = '';
		} else if ($alt == 'delimage') {
			if (unlink(CACHE_DIR . 'ASIN' . $asin . '.jpg')) {
				return 'Image of ' . $asin . ' deleted...';
			} else {
				return 'Image of ' . $asin . ' NOT DELETED...';
			}
		} elseif ($alt == 'deltitle') {
			if (unlink(CACHE_DIR . 'ASIN' . $asin . '.tit')) {
				return 'Title of ' . $asin . ' deleted...';
			} else {
				return 'Title of ' . $asin . ' NOT DELETED...';
			}
		} elseif ($alt == 'delete') {
			if ((unlink(CACHE_DIR . 'ASIN' . $asin . '.jpg') &&
			     unlink(CACHE_DIR . 'ASIN' . $asin . '.tit'))) {
				return 'Title and Image of ' . $asin . ' deleted...';
			} else {
				return 'Title and Image of ' . $asin . ' NOT DELETED...';
			}
		}
	} else {
		// ȥ뼫ư
		$alt = $title = plugin_amazon_get_asin_title();
		if ($alt == '') return FALSE;
	}

	return plugin_amazon_print_object($align, $alt, $title);
}

function plugin_amazon_action()
{
	global $vars, $script, $edit_auth, $edit_auth_users;
	global $amazon_body, $asin, $asin_all;

	if (PKWK_READONLY) die_message('PKWK_READONLY prohibits editing');

	$s_page   = isset($vars['refer']) ? $vars['refer'] : '';
	$asin_all = isset($vars['asin']) ?
		htmlspecialchars(rawurlencode(strip_bracket($vars['asin']))) : '';

	if (! is_asin()) {
		$retvars['msg']   = '֥åӥ塼Խ';
		$retvars['refer'] = & $s_page;
		$retvars['body']  = plugin_amazon_convert();
		return $retvars;

	} else {
		$r_page     = $s_page . '/' . $asin;
		$r_page_url = rawurlencode($r_page);
		$auth_user = isset($_SERVER['PHP_AUTH_USER']) ? $_SERVER['PHP_AUTH_USER'] : '';

		pkwk_headers_sent();
		if ($edit_auth && ($auth_user == '' || ! isset($edit_auth_users[$auth_user]) ||
		    $edit_auth_users[$auth_user] != $_SERVER['PHP_AUTH_PW'])) {
		    	// Edit-auth failed. Just look the page
			header('Location: ' . get_script_uri() . '?' . $r_page_url);
		} else {
			$title = plugin_amazon_get_asin_title();
			if ($title == '' || preg_match('#^/#', $s_page)) {
				// Invalid page name
				header('Location: ' . get_script_uri() . '?' . rawurlencode($s_page));
			} else {
				$body = '#amazon(' . $asin_all . ',,image)' . "\n" .
					'*' . $title . "\n" . $amazon_body;
				plugin_amazon_review_save($r_page, $body);
				header('Location: ' . get_script_uri() .
					'?cmd=edit&page=' . $r_page_url);
			}
		}
		exit;
	}
}

function plugin_amazon_inline()
{
	global $amazon_aid, $asin, $asin_all;

	list($asin_all) = func_get_args();

	$asin_all = htmlspecialchars($asin_all); // for XSS
	if (! is_asin()) return FALSE;

	$title = plugin_amazon_get_asin_title();
	if ($title == '') {
		return FALSE;
	} else {
		return '<a href="' . PLUGIN_AMAZON_SHOP_URI .
			$asin . '/' . $amazon_aid . 'ref=nosim">' . $title . '</a>' . "\n";
	}
}

function plugin_amazon_print_object($align, $alt, $title)
{
	global $amazon_aid;
	global $asin, $asin_ext, $asin_all;

	$url      = plugin_amazon_cache_image_fetch(CACHE_DIR);
	$url_shop = PLUGIN_AMAZON_SHOP_URI . $asin . '/' . $amazon_aid . 'ref=nosim';
	$center   = 'text-align:center';

	if ($title == '') {
		// Show image only
		$div  = '<div style="float:' . $align . ';margin:16px 16px 16px 16px;' . $center . '">' . "\n";
		$div .= ' <a href="' . $url_shop . '"><img src="' . $url . '" alt="' . $alt . '" /></a>' . "\n";
		$div .= '</div>' . "\n";

	} else {
		// Show image and title
		$div  = '<div style="float:' . $align . ';padding:.5em 1.5em .5em 1.5em;' . $center . '">' . "\n";
		$div .= ' <table style="width:110px;border:0;' . $center . '">' . "\n";
		$div .= '  <tr><td style="' . $center . '">' . "\n";
		$div .= '   <a href="' . $url_shop . '"><img src="' . $url . '" alt="' . $alt  .'" /></a></td></tr>' . "\n";
		$div .= '  <tr><td style="' . $center . '"><a href="' . $url_shop . '">' . $title . '</a></td></tr>' . "\n";
		$div .= ' </table>' . "\n";
		$div .= '</div>' . "\n";
	}
	return $div;
}

function plugin_amazon_get_asin_title()
{
	global $asin, $asin_ext, $asin_all;

	if ($asin_all == '') return '';

	$nocache = $nocachable = 0;

	$url = PLUGIN_AMAZON_XML . $asin;

	if (file_exists(CACHE_DIR) === FALSE || is_writable(CACHE_DIR) === FALSE) $nocachable = 1; // åԲĤξ

	if (($title = plugin_amazon_cache_title_fetch(CACHE_DIR)) == FALSE) {
		$nocache = 1; // å師Ĥ餺
		$body    = plugin_amazon_get_page($url); // ʤΤǼˤ
		$tmpary  = array();
		$body    = mb_convert_encoding($body, SOURCE_ENCODING, 'UTF-8');
		preg_match('/<ProductName>([^<]*)</', $body, $tmpary);
		$title     = trim($tmpary[1]);
//		$tmpary[1] = '';
//		preg_match('#<ImageUrlMedium>http://images-jp.amazon.com/images/P/[^.]+\.(..)\.#',
//			$body, $tmpary);
//		if ($tmpary[1] != '') {
//			$asin_ext = $tmpary[1];
//			$asin_all = $asin . $asin_ext;
//		}
	}

	if ($title == '') {
		return '';
	} else {
		if ($nocache == 1 && $nocachable != 1)
			plugin_amazon_cache_title_save($title, CACHE_DIR);
		return $title;
	}
}

// ȥ륭å夬뤫Ĵ٤
function plugin_amazon_cache_title_fetch($dir)
{
	global $asin, $asin_ext, $asin_all;

	$filename = $dir . 'ASIN' . $asin . '.tit';

	$get_tit = 0;
	if (! is_readable($filename)) {
		$get_tit = 1;
	} elseif (PLUGIN_AMAZON_EXPIRE_TITLECACHE * 3600 * 24 < time() - filemtime($filename)) {
		$get_tit = 1;
	}

	if ($get_tit) return FALSE;

	if (($fp = @fopen($filename, 'r')) === FALSE) return FALSE;
	$title = fgets($fp, 4096);
//	$tmp_ext = fgets($fp, 4096);
//	if ($tmp_ext != '') $asin_ext = $tmp_ext;
	fclose($fp);

	if (strlen($title) > 0) {
		return $title;
	} else {
		return FALSE;
	}
}

// å夬뤫Ĵ٤
function plugin_amazon_cache_image_fetch($dir)
{
	global $asin, $asin_ext, $asin_all;

	$filename = $dir . 'ASIN' . $asin . '.jpg';

	$get_img = 0;
	if (! is_readable($filename)) {
		$get_img = 1;
	} elseif (PLUGIN_AMAZON_EXPIRE_IMAGECACHE * 3600 * 24 < time() - filemtime($filename)) {
		$get_img = 1;
	}

	if ($get_img) {
		$url = 'http://images-jp.amazon.com/images/P/' . $asin . '.' . $asin_ext . '.MZZZZZZZ.jpg';
		if (! is_url($url)) return FALSE;

		$body = plugin_amazon_get_page($url);
		if ($body != '') {
			$tmpfile = $dir . 'ASIN' . $asin . '.jpg.0';
			$fp = fopen($tmpfile, 'wb');
			fwrite($fp, $body);
			fclose($fp);
			$size = getimagesize($tmpfile);
			unlink($tmpfile);
		}
		if ($body == '' || $size[1] <= 1) { // ̾1֤뤬ǰΤ0ξ(reimy)
			// å PLUGIN_AMAZON_NO_IMAGE ΥԡȤ
			if ($asin_ext == '09') {
				$url = 'http://images-jp.amazon.com/images/P/' . $asin . '.01.MZZZZZZZ.jpg';
				$body = plugin_amazon_get_page($url);
				if ($body != '') {
					$tmpfile = $dir . 'ASIN' . $asin . '.jpg.0';
					$fp = fopen($tmpfile, 'wb');
					fwrite($fp, $body);
					fclose($fp);
					$size = getimagesize($tmpfile);
					unlink($tmpfile);
				}
			}
			if ($body == '' || $size[1] <= 1) {
				$fp = fopen(PLUGIN_AMAZON_NO_IMAGE, 'rb');
				if (! $fp) return FALSE;
				
				$body = '';
				while (! feof($fp)) $body .= fread($fp, 4096);
				fclose ($fp);
			}
		}
		plugin_amazon_cache_image_save($body, CACHE_DIR);
	}
	return $filename;
}

// Save title cache
function plugin_amazon_cache_title_save($data, $dir)
{
	global $asin, $asin_ext, $asin_all;

	$filename = $dir . 'ASIN' . $asin . '.tit';
	$fp = fopen($filename, 'w');
	fwrite($fp, $data);
	fclose($fp);

	return $filename;
}

// Save image cache
function plugin_amazon_cache_image_save($data, $dir)
{
	global $asin, $asin_ext, $asin_all;

	$filename = $dir . 'ASIN' . $asin . '.jpg';
	$fp = fopen($filename, 'wb');
	fwrite($fp, $data);
	fclose($fp);

	return $filename;
}

// Save book data
function plugin_amazon_review_save($page, $data)
{
	global $asin, $asin_ext, $asin_all;

	$filename = DATA_DIR . encode($page) . '.txt';
	if (! is_readable($filename)) {
		$fp = fopen($filename, 'w');
		fwrite($fp, $data);
		fclose($fp);
		return TRUE;
	} else {
		return FALSE;
	}
}

function plugin_amazon_get_page($url)
{
	$data = http_request($url);
	return ($data['rc'] == 200) ? $data['data'] : '';
}

// is ASIN?
function is_asin()
{
	global $asin, $asin_ext, $asin_all;

	$tmpary = array();
	if (preg_match('/^([A-Z0-9]{10}).?([0-9][0-9])?$/', $asin_all, $tmpary) == FALSE) {
		return FALSE;
	} else {
		$asin     = $tmpary[1];
		$asin_ext = isset($tmpary[2]) ? $tmpary[2] : '';
		if ($asin_ext == '') $asin_ext = '09';
		$asin_all = $asin . $asin_ext;
		return TRUE;
	}
}
?>
