
#include <qpushbutton.h>
#include <qiconview.h>
#include <qfileinfo.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtimer.h>

#include "global.h"
#include "previewer.h"
//#include "cachethumbs.h"


namespace Input
{

Previewer::Previewer ( QWidget *pParent, QIconView *pPreview )
  : uiPreviewer ( pParent )
{
  m_pCurrentItem = NULL;
  m_pIconView    = pPreview;
  pParent->layout ( )->add ( this );

  connect ( m_pButtonFirst, SIGNAL ( clicked ( ) ), this, SLOT ( slotFirst ( ) ) );
  connect ( m_pButtonLast,  SIGNAL ( clicked ( ) ), this, SLOT ( slotLast  ( ) ) );
  connect ( m_pButtonNext,  SIGNAL ( clicked ( ) ), this, SLOT ( slotNext  ( ) ) );
  connect ( m_pButtonPrev,  SIGNAL ( clicked ( ) ), this, SLOT ( slotPrev  ( ) ) );
  hide ( );
}

Previewer::~Previewer ( )
{
}

void Previewer::setItem ( Cache::Thumbs::Entry *pCache, QIconViewItem *pItem )
{
  QImage   largeImg;
  QPixmap  largePix;
  QWidget *pParent = parentWidget  (    );
  QSize    size    = pParent->size (    );
  size.setWidth  ( size.width  ( ) - 30 );
  size.setHeight ( size.height ( ) - 30 );

  m_pCurrentItem = pItem;
  m_pMatrix      = pCache->getMatrix ( );
  setButtonState  ( );

  if ( pCache->getMatrix ( ) )  {
    largeImg = pCache->arrayOfThumbs[0]->xForm  ( *pCache->getMatrix  ( ) );
    largeImg = largeImg.smoothScale ( size.width( ) - 175, size.height( ), QImage::ScaleMin );
  }
  else
    largeImg = pCache->arrayOfThumbs[0]->smoothScale ( size.width( ) - 175, size.height( ), QImage::ScaleMin );

  largePix.convertFromImage ( largeImg );
  m_pPreview ->setPixmap    ( largePix );
  if ( m_pIconView->isVisible ( ) )  {
    m_pIconView->hide ( );

    move   ( 2, 2 );
    resize ( size.width ( ) - 4, size.height ( ) - 4 );
    show   ( );
    raise  ( );
  }
  QTimer::singleShot ( 5, this, SLOT ( slotShowImageInfo ( ) ) );
}

void Previewer::setItem ( QIconViewItem *pItem )
{
  if ( ! pItem )
    return;

  QString qsFileName = pItem->key ( );
  Cache::Thumbs::Entry *pCache = Global::pThumbsCache->find ( qsFileName, true );
  setItem ( pCache, pItem );
}

void Previewer::setButtonState ( )
{
  if ( ! m_pCurrentItem )
    return;
  // Enables / disables buttons based on the item being first last, or neither.
}

void Previewer::mouseReleaseEvent ( QMouseEvent *pEvent )
{
  if ( pEvent->pos ( ).x ( ) > width ( ) - 175 )
    return;

  clear ( );
}

void Previewer::clear ( )
{
  hide ( );
  m_pIconView->show ( );
  if ( m_pCurrentItem )
    m_pIconView->ensureItemVisible ( m_pCurrentItem );
}

void Previewer::slotLoadWholeImage ( )
{
  if ( ! m_pCurrentItem )
    return;

  QWidget *pParent  =  parentWidget  (    );
  QSize    size     =  pParent->size (    );
  size.setWidth    ( size.width  ( ) - 30 );
  size.setHeight   ( size.height ( ) - 30 );
  QImage  theImage ( m_pCurrentItem->key( ) );
  QPixmap thePixmap;

  if ( m_pMatrix )  {
    theImage = theImage.xForm ( *m_pMatrix );
    theImage = theImage.smoothScale ( size.width( ) - 175, size.height( ), QImage::ScaleMin );
  }
  else
    theImage = theImage.smoothScale ( size.width( ) - 175, size.height( ), QImage::ScaleMin );
//  theImage = theImage.smoothScale ( size, QImage::ScaleMin );

  thePixmap.convertFromImage ( theImage  );
  m_pPreview ->setPixmap     ( thePixmap );

  m_pIconView->clearSelection ( );
  m_pCurrentItem->setSelected ( true );
}

void Previewer::slotShowImageInfo ( )
{
  if ( ! m_pCurrentItem )
    return;

  QString qsText, qsFileName;
  jhead::JHead *pPlugin = Global::pThumbsCache->plugin ( );

  qsFileName = m_pCurrentItem->key ( );
  QFileInfo fileInfo ( qsFileName );

  qsText  = tr ( "<font size=\"-4\"><table>" );
//  qsText += tr ( "<tr><td colspan=\"2\" bgcolor=\"#ffee44\">Name :</td></tr>" );
  qsText += tr ( "<tr><td colspan=\"2\" bgcolor=\"#ffee44\"><b>%1</b></td></tr>" ).arg ( fileInfo.fileName ( ) );

  if ( ! pPlugin )  {
    qsText += tr ( "<tr><td>Size :</td><td><b>%1</b></td></tr>" ).arg ( fileInfo.size     ( ) );
    qsText += tr ( "<tr><td>Created :</td><td><b>%1</b></td></tr>" ).arg ( fileInfo.created  ( ).toString ( "yyyy/MM/dd hh:mm:ss" ) );
    qsText += tr ( "</table><p><b>Could not find libjhead plugin</b></font>" );
  }
  else  {
    jhead::JHead::Info *pInfo = pPlugin->getFileInfo ( qsFileName );
    if ( pInfo )  {
      QString qsOrientation = "Upside Down";

//      qsText += tr ( "<tr><td colspan=\"2\" bgcolor=\"#ff0000\"><b></b></td></tr>" );
      qsText += tr ( "<tr><td>Make :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->qsCamera );
      qsText += tr ( "<tr><td>Model :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->qsModel );
      qsText += tr ( "<tr><td>Date :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->imageDate.toString ( "yyyy/MM/dd hh:mm:ss" ) );
//      qsText += tr ( "<tr><td>Orient.:</td><td><b>%1</b></td></tr>" ).arg ( qsOrientation );
      qsText += tr ( "<tr><td>Res. :</td><td><b>%1 x %2</b></td></tr>" ).arg ( pInfo->iWidth ).arg ( pInfo->iHeight );
      if ( ! pInfo->bIsColor )
        qsText += tr ( "<tr><td>Color/bw :</td><td><b>Black and White</b></td></tr>" );
      qsText += tr ( "<tr><td>Flash :</td><td><b>%1</b></td></tr>" ).arg ( ( pInfo->iFlashFlags & 1 ) ? "Yes" : "No");
      qsText += tr ( "<tr><td>Focal :</td><td><b>%1mm</b></td></tr>" ).arg ( pInfo->fFocalLength, 0, 'g', 2 );
      qsText += tr ( "<tr><td>CCDWidth :</td><td><b>%1mm</b></td></tr>" ).arg ( pInfo->fCCDWidth, 0, 'g', 2 );
      qsText += tr ( "<tr><td>Exposure :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->fExposureTime );
      qsText += tr ( "<tr><td>Focal :</td><td><b>f/%1</b></td></tr>" ).arg ( pInfo->fAperture );
      if ( pInfo->fDigitalZoom > 1.0f )
        qsText += tr ( "<tr><td>Digi Zoom :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->fDigitalZoom );
      if ( pInfo->iISOEquiv )
        qsText += tr ( "<tr><td>ISO Equiv :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->iISOEquiv );
      if ( pInfo->fExposureBias > 0.0 )
        qsText += tr ( "<tr><td>Expos Bias :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->fExposureBias );
      qsText += tr ( "<tr><td>Whitebal :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->bWhitebalance ? "Manual" : "Auto" );

//    qsText += tr ( "<tr><td>Focal :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->fFocalLength );
//    qsText += tr ( "<tr><td>Focal :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->fFocalLength );
//    qsText += tr ( "<tr><td>Focal :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->fFocalLength );
//    qsText += tr ( "<tr><td>Focal :</td><td><b>%1</b></td></tr>" ).arg ( pInfo->fFocalLength );

//    GPSInfo  *pGPSInfo;
//    int       iLightsource;
//    int       iOrientation;
//    int       iFlashFlags;
//    int       iExposureProg;
//    int       iDistanceRange;

      if ( ! pInfo->qsComment.isEmpty ( ) ) 
        qsText += tr ( "<tr><td colspan=\"2\" bgcolor=\"#33ff33\"><b>%1</b></td></tr>" ).arg ( pInfo->qsComment );
      delete pInfo;
    }
    qsText += tr ( "</table></font>" );
  }
  m_pLabelInfo->setText ( qsText );
  QTimer::singleShot ( 5, this, SLOT ( slotLoadWholeImage ( ) ) );
}

/*
    iLightsource
    switch(ImageInfo.LightSource) {
        case 1:
            printf("Light Source : Daylight\n");
            break;
        case 2:
            printf("Light Source : Fluorescent\n");
            break;
        case 3:
            printf("Light Source : Incandescent\n");
            break;
        case 4:
            printf("Light Source : Flash\n");
            break;
        case 9:
            printf("Light Source : Fine weather\n");
            break;
        case 11:
            printf("Light Source : Shade\n");
            break;
        default:; //Quercus: 17-1-2004 There are many more modes for this, check Exif2.2 specs
            // If it just says 'unknown' or we don't know it, then
            // don't bother showing it - it doesn't add any useful information.
    }


    int       iOrientation;
    "Undefined",
    "Normal",           // 1
    "flip horizontal",  // left right reversed mirror
    "rotate 180",       // 3
    "flip vertical",    // upside down mirror
    "transpose",        // Flipped about top-left <--> bottom-right axis.
    "rotate 90",        // rotate 90 cw to right it.
    "transverse",       // flipped about top-right <--> bottom-left axis
    "rotate 270",       // rotate 270 to right it.


    if (ImageInfo.FlashUsed >= 0){
        if (ImageInfo.FlashUsed & 1){    
            printf("Flash used   : Yes");
            switch (ImageInfo.FlashUsed){
	            case 0x5: printf(" (Strobe light not detected)"); break;
	            case 0x7: printf(" (Strobe light detected) "); break;
	            case 0x9: printf(" (manual)"); break;
	            case 0xd: printf(" (manual, return light not detected)"); break;
	            case 0xf: printf(" (manual, return light  detected)"); break;
	            case 0x19:printf(" (auto)"); break;
	            case 0x1d:printf(" (auto, return light not detected)"); break;
	            case 0x1f:printf(" (auto, return light detected)"); break;
	            case 0x41:printf(" (red eye reduction mode)"); break;
	            case 0x45:printf(" (red eye reduction mode return light not detected)"); break;
	            case 0x47:printf(" (red eye reduction mode return light  detected)"); break;
	            case 0x49:printf(" (manual, red eye reduction mode)"); break;
	            case 0x4d:printf(" (manual, red eye reduction mode, return light not detected)"); break;
	            case 0x4f:printf(" (red eye reduction mode, return light detected)"); break;
	            case 0x59:printf(" (auto, red eye reduction mode)"); break;
	            case 0x5d:printf(" (auto, red eye reduction mode, return light not detected)"); break;
	            case 0x5f:printf(" (auto, red eye reduction mode, return light detected)"); break;
            }
        }else{
            printf("Flash used   : No");
            switch (ImageInfo.FlashUsed){
	            case 0x18:printf(" (auto)"); break;
            }
        }
*/

void Previewer::slotFirst ( )
{
  if ( ! m_pCurrentItem )
    return;

  setItem ( m_pIconView->firstItem ( ) );
}

void Previewer::slotLast ( )
{
  if ( ! m_pCurrentItem )
    return;

  setItem ( m_pIconView->lastItem ( ) );
}

void Previewer::slotNext ( )
{
  if ( ! m_pCurrentItem )
    return;

  setItem ( m_pCurrentItem->nextItem ( ) );
}

void Previewer::slotPrev ( )
{
  if ( ! m_pCurrentItem )
    return;

  setItem ( m_pCurrentItem->prevItem ( ) );
}

}; // End of namespace Input
