/****************************************************************************
** Class Previewer
**
**   Created : Tue Jun 3 09:13:25 2008
**        by : Varol Okan, using Kate
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** Previewer for the DialogFiles / DialogImages - classes
**
****************************************************************************/

#ifndef PREVIEWER_H
#define PREVIEWER_H

#include "cachethumbs.h"
#include "uipreviewer.h"

class QIconView;
class QIconViewItem;

namespace Input
{

class Previewer : public uiPreviewer
{  // Class to overlay on top of the QIconVIew
   //  to give a preview of the Image / Video
  Q_OBJECT
public:
   Previewer ( QWidget *, QIconView * );
  ~Previewer ( );

  // Sets the item to be displayed in more detail.
  void setItem ( Cache::Thumbs::Entry *, QIconViewItem * );
  void setItem ( QIconViewItem * );
  void clear   ( );

protected slots:
  virtual void slotFirst ( );
  virtual void slotLast  ( );
  virtual void slotNext  ( );
  virtual void slotPrev  ( );
  virtual void slotLoadWholeImage ( );
  virtual void slotShowImageInfo  ( );

protected:
  virtual void mouseReleaseEvent  ( QMouseEvent * );

  void setButtonState ( );

  QWMatrix      *m_pMatrix;
  QIconView     *m_pIconView;
  QIconViewItem *m_pCurrentItem;
};

};  // End of namespace Input

#endif // DIALOGALIGN_H
