/********************************************************************************
 *   This file is part of QSvn Project http://www.anrichter.net/projects/qsvn   *
 *   Copyright (c) 2004-2008 Andreas Richter <ar@anrichter.net>                 *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License Version 2             *
 *   as published by the Free Software Foundation.                              *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.                  *
 *                                                                              *
 *******************************************************************************/

//QSvn
#include "helper.h"

//Qt
#include <QtCore>


bool Helper::removeFromDisk(QString aPath)
{
    bool result = true;
    QDir dir = QDir(aPath);
    dir.setFilter(QDir::NoDotAndDotDot | QDir::Files | QDir::Hidden | QDir::Dirs);
    foreach(QFileInfo fileInfo, dir.entryInfoList())
    {
        if(fileInfo.isFile())
		{
            QFile::setPermissions(fileInfo.filePath(), QFile::WriteOwner | QFile::ReadOwner);
			result &= QFile::remove(fileInfo.filePath());
		} 
		else if(fileInfo.isDir())
        {
            result &= Helper::removeFromDisk(fileInfo.filePath());
        }
    }
    result &= dir.rmdir(aPath);
    return result;
}


#include "helper.moc"
