/* vim:set noet ts=4: */
/** 
 * scim-python
 * 
 * Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: $
 */
#include <Python.h>
#include "structmember.h"
#include "scim-python-property.h"

struct PyProperty {
	PyObject_HEAD
	/* Type-specific fields go here. */
	Property prop;
};

static PyObject *
PyProperty_new (PyTypeObject *type, PyObject *args, PyObject *kwds)
{
       PyProperty *self;

       self = (PyProperty *)type->tp_alloc (type, 0);
       return (PyObject *)self;
}

static int
PyProperty_init (PyProperty *self, PyObject *args, PyObject *kwds)
{
	char *key = NULL;
	char *label = NULL;
	char *icon = NULL;
	char *tip = NULL;

	if (!PyArg_ParseTuple (args, "ss|ss:__init__", &key, &label, &icon, &tip))
		return -1;

	if (icon == NULL)
		icon = "";
	if (tip == NULL)
		tip = "";

	new (&self->prop) Property (String (key), String (label), String (icon), String (tip));
	return 0;
}

static void
PyProperty_dealloc (PyProperty *self)
{
	self->prop.~Property ();
	((PyObject *)self)->ob_type->tp_free (self);
}

static PyMethodDef PyProperty_methods[] = {
#if 0
	{ "show_preedit_string", (PyCFunction)PythonInstance::_show_preedit_string, METH_NOARGS,
	 "Return the name, combining the first and last name"
	},
#endif
	{NULL}  /* Sentinel */
};

static PyMemberDef PyProperty_members[] = {
	{NULL}  /* Sentinel */
};

static PyObject *
PyProperty_get_key (PyProperty *self, void *closure)
{
	return PyString_FromString (self->prop.get_key ().c_str ());
}

static int
PyProperty_set_key (PyProperty *self, PyObject *value, void *closure)
{
	if (value == NULL) {
		PyErr_SetString (PyExc_TypeError,
						"Cannot delete the key attribute");
		return -1;
	}

	if (! PyString_Check (value)) {
		PyErr_SetString (PyExc_TypeError, 
						"The key attribute value must be a string");
		return -1;
	}

	self->prop.set_key (String (PyString_AsString (value)));

	return 0;
}

static PyObject *
PyProperty_get_label (PyProperty *self, void *closure)
{
	return PyString_FromString (self->prop.get_label ().c_str ());
}

static int
PyProperty_set_label (PyProperty *self, PyObject *value, void *closure)
{
	if (value == NULL) {
		PyErr_SetString (PyExc_TypeError,
						"Cannot delete the label attribute");
		return -1;
	}

	if (! PyString_Check (value)) {
		PyErr_SetString (PyExc_TypeError, 
						"The key attribute label must be a string");
		return -1;
	}

	self->prop.set_label (String (PyString_AsString (value)));

	return 0;
}

static PyObject *
PyProperty_get_icon (PyProperty *self, void *closure)
{
	return PyString_FromString (self->prop.get_icon ().c_str ());
}

static int
PyProperty_set_icon (PyProperty *self, PyObject *value, void *closure)
{
	if (value == NULL) {
		PyErr_SetString (PyExc_TypeError,
						"Cannot delete the icon attribute");
		return -1;
	}

	if (! PyString_Check (value)) {
		PyErr_SetString (PyExc_TypeError, 
						"The icon attribute value must be a string");
		return -1;
	}

	self->prop.set_icon (String (PyString_AsString (value)));

	return 0;
}

static PyObject *
PyProperty_get_tip (PyProperty *self, void *closure)
{
	return PyString_FromString (self->prop.get_tip ().c_str ());
}

static int
PyProperty_set_tip (PyProperty *self, PyObject *value, void *closure)
{
	if (value == NULL) {
		PyErr_SetString (PyExc_TypeError,
						"Cannot delete the tip attribute");
		return -1;
	}

	if (! PyString_Check (value)) {
		PyErr_SetString (PyExc_TypeError, 
						"The tip attribute value must be a string");
		return -1;
	}

	self->prop.set_tip (String (PyString_AsString (value)));

	return 0;
}
static PyGetSetDef PyProperty_getseters[] = {
	{"key", (getter)PyProperty_get_key, (setter)PyProperty_set_key,
		"Key", NULL},
	{"label", (getter)PyProperty_get_label, (setter)PyProperty_set_label,
		"label", NULL},
	{"icon", (getter)PyProperty_get_icon, (setter)PyProperty_set_icon,
		"icon", NULL},
	{"tip", (getter)PyProperty_get_tip, (setter)PyProperty_set_tip,
		"tip", NULL},
	{NULL}  /* Sentinel */
};

static PyTypeObject PyPropertyType = {
	PyObject_HEAD_INIT (NULL)
	0,						 	/*ob_size*/
	"scim.Property", 			/*tp_name*/
	sizeof (PyProperty), 		/*tp_basicsize*/
	0,						 	/*tp_itemsize*/
	(destructor) PyProperty_dealloc,	/*tp_dealloc*/
	0,			  				/*tp_print*/
	0,						 	/*tp_getattr*/
	0,							/*tp_setattr*/
	0,							/*tp_compare*/
	0,			  				/*tp_repr*/
	0,							/*tp_as_number*/
	0,			  				/*tp_as_sequence*/
	0,							/*tp_as_mapping*/
	0,			  				/*tp_hash */
	0,							/*tp_call*/
	0,							/*tp_str*/
	0,					   		/*tp_getattro*/
	0,							/*tp_setattro*/
	0,					 		/*tp_as_buffer*/
	Py_TPFLAGS_DEFAULT,			/*tp_flags*/
	"Property objects",			/* tp_doc */
	0,					   		/* tp_traverse */
	0,					   		/* tp_clear */
	0,					   		/* tp_richcompare */
	0,					   		/* tp_weaklistoffset */
	0,					   		/* tp_iter */
	0,					   		/* tp_iternext */
	PyProperty_methods,			/* tp_methods */
	PyProperty_members,			/* tp_members */
	PyProperty_getseters,		/* tp_getset */
	0,						 	/* tp_base */
	0,						 	/* tp_dict */
	0,						 	/* tp_descr_get */
	0,						 	/* tp_descr_set */
	0,						 	/* tp_dictoffset */
	(initproc)PyProperty_init,	/* tp_init */
	0,						 	/* tp_alloc */
	PyProperty_new,				/* tp_new */	
	PyObject_Del,				/* tp_free */	
};


Property&
PyProperty_AsProperty (PyObject *self)
{
	return ((PyProperty *)self)->prop;
}

void init_property (PyObject *module)
{
	if (PyType_Ready (&PyPropertyType) < 0)
		return;
	Py_INCREF (&PyPropertyType);
	PyModule_AddObject (module, "Property", (PyObject *)&PyPropertyType);
}

