# -*- coding: utf-8 -*-
# vim:set noet ts=4:
#
# scim-python
#
# Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA
#
# $Id: $
#
import scim
import gtk 
from os import path
from glob import glob
from gettext import dgettext
_ = lambda (a) : dgettext ("scim-python", a)
N_ = lambda (a) : a

window = None
setup_uis = None

def create_ui ():
	global window
	global setup_uis
	if window != None:
		return window
	window = gtk.Notebook ()
	wildcast = path.join (path.dirname (__file__), "*")

	setup_uis = []
	for name in [name for name in glob (wildcast) if path.isdir(name)]:
		try:
			name = path.basename (name)
			mod = __import__ (name, globals (), locals (), [])
			for ui in mod.SetupUI:
				widget = ui ()
				window.append_page (widget, gtk.Label (widget.get_name ()))
				setup_uis.append (widget)
		except Exception, e:
			print e
	about_page = gtk.Label (_("scim-python\n\nAuthor: Huang Peng <shawn.p.huang@gmail.com>"))
	about_page.set_justify (gtk.JUSTIFY_CENTER)
	window.append_page (about_page, gtk.Label(_("About")))
	window.show_all ()
	return window

def load_config (config):
	for widget in setup_uis:
		try:
			widget.load_config (config)
		except:
			import traceback
			traceback.print_exc ()

def save_config (config):
	for widget in setup_uis:
		try:
			widget.save_config (config)
		except:
			import traceback
			traceback.print_exc ()

def query_changed ():
	for widget in setup_uis:
		try:
			if widget.query_changed ():
				return True
		except:
			import traceback
			traceback.print_exc ()
	return False

if __name__ == "__main__":
	w = gtk.Window ()
	w.add (create_ui ())
	w.connect ("delete-event", gtk.main_quit)
	w.resize (400, 400)
	w.show_all ()
	gtk.main ()

