/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "sgtk-hig.h"
#include "st-preferences-page.h"

/*** type definitions ********************************************************/

struct _STPreferencesPagePrivate
{
  char		*name;
  GdkPixbuf	*icon;
  char		*stock_id;
  char		*label;
  char		*help_link_id;
};

/*** variable declarations ***************************************************/

static GObjectClass *parent_class = NULL;

/*** function declarations ***************************************************/

static void st_preferences_page_class_init (STPreferencesPageClass *class);
static void st_preferences_page_init (STPreferencesPage *page);
static void st_preferences_page_finalize (GObject *object);

/*** implementation **********************************************************/

GType
st_preferences_page_get_type (void)
{
  static GType preferences_page_type = 0;
  
  if (! preferences_page_type)
    {
      static const GTypeInfo preferences_page_info = {
	sizeof(STPreferencesPageClass),
	NULL,
	NULL,
	(GClassInitFunc) st_preferences_page_class_init,
	NULL,
	NULL,
	sizeof(STPreferencesPage),
	0,
	(GInstanceInitFunc) st_preferences_page_init,
      };

      preferences_page_type = g_type_register_static(GTK_TYPE_VBOX,
						     "STPreferencesPage",
						     &preferences_page_info,
						     0);
    }
  
  return preferences_page_type;
}

static void
st_preferences_page_class_init (STPreferencesPageClass *class)
{
  GObjectClass *object_class = G_OBJECT_CLASS(class);

  parent_class = g_type_class_peek_parent(class);

  g_type_class_add_private(class, sizeof(STPreferencesPagePrivate));

  object_class->finalize = st_preferences_page_finalize;
}

static void
st_preferences_page_init (STPreferencesPage *page)
{
  page->priv = G_TYPE_INSTANCE_GET_PRIVATE(page, ST_TYPE_PREFERENCES_PAGE, STPreferencesPagePrivate);
  gtk_box_set_spacing(GTK_BOX(page), SGTK_HIG_CONTROL_SPACING);
}

static void
st_preferences_page_finalize (GObject *object)
{
  STPreferencesPage *page = ST_PREFERENCES_PAGE(object);

  if (page->priv->icon)
    g_object_unref(page->priv->icon);

  g_free(page->priv->label);
  g_free(page->priv->help_link_id);

  parent_class->finalize(object);
}

void
st_preferences_page_set_name (STPreferencesPage *page, const char *name)
{
  g_return_if_fail(ST_IS_PREFERENCES_PAGE(page));

  g_free(page->priv->name);
  page->priv->name = g_strdup(name);
}

const char *
st_preferences_page_get_name (STPreferencesPage *page)
{
  g_return_val_if_fail(ST_IS_PREFERENCES_PAGE(page), NULL);

  return page->priv->name;
}

void
st_preferences_page_set_icon (STPreferencesPage *page, GdkPixbuf *icon)
{
  g_return_if_fail(ST_IS_PREFERENCES_PAGE(page));

  if (page->priv->icon)
    g_object_unref(page->priv->icon);

  page->priv->icon = icon ? g_object_ref(icon) : NULL;
}

GdkPixbuf *
st_preferences_page_get_icon (STPreferencesPage *page)
{
  g_return_val_if_fail(ST_IS_PREFERENCES_PAGE(page), NULL);

  return page->priv->icon;
}

void
st_preferences_page_set_stock_id (STPreferencesPage *page,
				  const char *stock_id)
{
  g_return_if_fail(ST_IS_PREFERENCES_PAGE(page));

  g_free(page->priv->stock_id);
  page->priv->stock_id = g_strdup(stock_id);
}

const char *
st_preferences_page_get_stock_id (STPreferencesPage *page)
{
  g_return_val_if_fail(ST_IS_PREFERENCES_PAGE(page), NULL);

  return page->priv->stock_id;
}

void
st_preferences_page_set_label (STPreferencesPage *page, const char *label)
{
  g_return_if_fail(ST_IS_PREFERENCES_PAGE(page));

  g_free(page->priv->label);
  page->priv->label = g_strdup(label);
}

const char *
st_preferences_page_get_label (STPreferencesPage *page)
{
  g_return_val_if_fail(ST_IS_PREFERENCES_PAGE(page), NULL);

  return page->priv->label;
}

void
st_preferences_page_set_help_link_id (STPreferencesPage *page,
				      const char *help_link_id)
{
  g_return_if_fail(ST_IS_PREFERENCES_PAGE(page));

  g_free(page->priv->help_link_id);
  page->priv->help_link_id = g_strdup(help_link_id);
}

const char *
st_preferences_page_get_help_link_id (STPreferencesPage *page)
{
  g_return_val_if_fail(ST_IS_PREFERENCES_PAGE(page), NULL);

  return page->priv->help_link_id;
}

STPreferencesPage *
st_preferences_page_new (void)
{
  return g_object_new(ST_TYPE_PREFERENCES_PAGE, NULL);
}
