'\"
'\" Copyright (c) 1993-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: break.n,v 1.10 2007/12/13 15:22:32 dgp Exp $
'\" 
.so man.macros
.TH break n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
break \- Abort looping command
.SH SYNOPSIS
\fBbreak\fR
.BE

.SH DESCRIPTION
.PP
This command is typically invoked inside the body of a looping command
such as \fBfor\fR or \fBforeach\fR or \fBwhile\fR.
It returns a \fBTCL_BREAK\fR code, which causes a break exception
to occur.
The exception causes the current script to be aborted
out to the innermost containing loop command, which then
aborts its execution and returns normally.
Break exceptions are also handled in a few other situations, such
as the \fBcatch\fR command, Tk event bindings, and the outermost
scripts of procedure bodies.
.SH EXAMPLE
Print a line for each of the integers from 0 to 5:
.CS
for {set x 0} {$x<10} {incr x} {
   if {$x > 5} {
      \fBbreak\fR
   }
   puts "x is $x"
}
.CE

.SH "SEE ALSO"
catch(n), continue(n), for(n), foreach(n), return(n), while(n)

.SH KEYWORDS
abort, break, loop
