[manpage_begin math::fourier n 1.0.2]
[moddesc {Tcl Math Library}]
[titledesc {Discrete and fast fourier transforms}]
[require Tcl 8.4]
[require math::fourier 1.0.2]
[description]
[para]

The [package math::fourier] package implements two versions of discrete
Fourier transforms, the ordinary transform and the fast Fourier
transform. It also provides a few simple filter procedures as an
illustrations of how such filters can be implemented.

[para]
The purpose of this document is to describe the implemented procedures
and provide some examples of their usage. As there is ample literature
on the algorithms involved, we refer to relevant text books for more
explanations. We also refer to the original Wiki page on the subject
which describes some of the considerations behind the current
implementation.

[section "GENERAL INFORMATION"]
The two top-level procedures defined are
[list_begin itemized]
[item]
dft data-list
[item]
inverse_dft data-list
[list_end]

Both take a list of [emph "complex numbers"] and apply a Discrete Fourier
Transform (DFT) or its inverse respectively to these lists of numbers.
A "complex number" in this case is either (i) a pair (two element list) of
numbers, interpreted as the real and imaginary parts of the complex number,
or (ii) a single number, interpreted as the real part of a complex number
whose imaginary part is zero. The return value is always in the
first format. (The DFT generally produces complex results even if the
input is purely real.) Applying first one and then the other of these
procedures to a list of complex numbers will (modulo rounding errors
due to floating point arithmetic) return the original list of numbers.

[para]
If the input length N is a power of two then these procedures will
utilize the O(N log N) Fast Fourier Transform algorithm. If input
length is not a power of two then the DFT will instead be computed
using a the naive quadratic algorithm.

[para]
Some examples:
[example {
    % dft {1 2 3 4}
    {10 0.0} {-2.0 2.0} {-2 0.0} {-2.0 -2.0}
    % inverse_dft {{10 0.0} {-2.0 2.0} {-2 0.0} {-2.0 -2.0}}
    {1.0 0.0} {2.0 0.0} {3.0 0.0} {4.0 0.0}
    % dft {1 2 3 4 5}
    {15.0 0.0} {-2.5 3.44095480118} {-2.5 0.812299240582} {-2.5 -0.812299240582} {-2.5 -3.44095480118}
    % inverse_dft {{15.0 0.0} {-2.5 3.44095480118} {-2.5 0.812299240582} {-2.5 -0.812299240582} {-2.5 -3.44095480118}}
    {1.0 0.0} {2.0 8.881784197e-17} {3.0 4.4408920985e-17} {4.0 4.4408920985e-17} {5.0 -8.881784197e-17}
}]
[para]
In the last case, the imaginary parts <1e-16 would have been zero in exact
arithmetic, but aren't here due to rounding errors.

[para]
Internally, the procedures use a flat list format where every even
index element of a list is a real part and every odd index element
is an imaginary part. This is reflected in the variable names by Re_
and Im_ prefixes.

[para]
The package includes two simple filters. They have an analogue
equivalent in a simple electronic circuit, a resistor and a capacitance
in series. Using these filters requires the
[package math::complexnumbers] package.


[section "PROCEDURES"]
The public Fourier transform procedures are:

[list_begin definitions]

[call [cmd ::math::fourier::dft] [arg in_data]]
Determine the [emph "Fourier transform"] of the given list of complex
numbers. The result is a list of complex numbers representing the
(complex) amplitudes of the Fourier components.

[list_begin arguments]
[arg_def list in_data] List of data
[list_end]
[para]

[call [cmd ::math::fourier::inverse_dft] [arg in_data]]
Determine the [emph "inverse Fourier transform"] of the given list of
complex numbers (interpreted as amplitudes). The result is a list of
complex numbers representing the original (complex) data

[list_begin arguments]
[arg_def list in_data] List of data (amplitudes)
[list_end]
[para]

[call [cmd ::math::fourier::lowpass] [arg cutoff] [arg in_data]]
Filter the (complex) amplitudes so that high-frequency components
are suppressed. The implemented filter is a first-order low-pass filter,
the discrete equivalent of a simple electronic circuit with a resistor
and a capacitance.

[list_begin arguments]
[arg_def float cutoff] Cut-off frequency
[arg_def list in_data] List of data (amplitudes)
[list_end]
[para]

[call [cmd ::math::fourier::highpass] [arg cutoff] [arg in_data]]
Filter the (complex) amplitudes so that low-frequency components
are suppressed. The implemented filter is a first-order low-pass filter,
the discrete equivalent of a simple electronic circuit with a resistor
and a capacitance.

[list_begin arguments]
[arg_def float cutoff] Cut-off frequency
[arg_def list in_data] List of data (amplitudes)
[list_end]
[para]

[list_end]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph {math :: fourier}] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords mathematics "FFT" "Fourier transform" "complex numbers"]
[manpage_end]
