//////////////////////////////////////////////////////////////////////////////
// Name:        calculette.h
// Purpose:     Application to make simple operations
// Author:      Laurent Bessard
// Created:     2005/05/09
// RCS-ID:      $Id: calculette.h,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#ifndef CALCULETTE_H
#define CALCULETTE_H

#include <wx/wx.h>
#include <wxSVG/svgctrl.h>
#include <wxXML/xml.h>
#include "SVGUIWindow.h"
#include "SVGUIButton.h"
#include "SVGUITextCtrl.h"
#include "SVGUIScrollBar.h"
#include <wx/xrc/xmlres.h>

#include "NumKbd.h"
#include "TrigoKbd.h"

class SVGViewApp: public wxApp
{
  public:
    bool OnInit();
};

enum OPERATION_TYPE
{
  NO = 0,
  PLUS = 1,
  MOINS = 2,
  MULTIPLIER = 3,
  DIVISER = 4
};

class Calculette: public SVGUIWindow
{
public:
    Calculette(wxWindow* parent);
    wxWindow* CreateWindow(const wxString& classname);
    void OnSize(wxSizeEvent& event);
    
    void OnBoutonACClick(wxCommandEvent& event);
	void OnChar(wxKeyEvent& event);
	void SetNombreValue(const wxString value);
	void Calculer();
	void Erase();
	void Error();

private:

	bool m_first_key;
	double m_result;
	int m_operation;
	
    DECLARE_EVENT_TABLE()
};

class MainFrame: public wxFrame
{
  public:
    MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,
      const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);

  protected:
    Calculette* m_svgCtrl;
};

#endif //CALCULETTE_H
