//////////////////////////////////////////////////////////////////////////////
// Name:        SVGUIControl.h
// Purpose:     
// Author:      Laurent Bessard
// Created:     2005/07/28
// RCS-ID:      $Id: SVGUIControl.h,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#ifndef SVGUI_CONTROL_H
#define SVGUI_CONTROL_H

#include <wx/wx.h>
#include <wxSVG/svg.h>
#include <wxSVG/SVGElement.h>
#include <wxSVG/CSSValue.h>
#include "SVGUIElement.h"

void SetDisplay(wxSVGElement* elem, wxCSS_VALUE value);
wxSVGRect GetElementBBox(const wxSVGElement& elem);
wxSVGMatrix GetElementCTM(const wxSVGElement& elem);
wxSVGTransformable* GetTransformable(const wxSVGElement& elem);
wxSVGRect SumBBox(wxSVGRect bbox1, wxSVGRect bbox2);

class SVGUIControl:
	public SVGUIElement,
	public wxEvtHandler
{
	protected:
		wxEvtHandler* m_window;
		
	public:
		SVGUIControl(){};
		SVGUIControl(wxSVGDocument* doc, wxEvtHandler* window);
		
		void Refresh();
		
		virtual bool HitTest(wxPoint pt);
		virtual wxSVGRect GetBBox();
		virtual void SendMouseEvent(wxMouseEvent& event);
		virtual void SendKeyEvent(wxKeyEvent& event);
		virtual void Update_Elements() = 0;

		virtual void OnLeftDown(wxMouseEvent& event);		
		virtual void OnLeftUp(wxMouseEvent& event);
		virtual void OnMotion(wxMouseEvent& event);
		virtual void OnChar(wxKeyEvent& event);

		DECLARE_EVENT_TABLE()
};

#endif //SVGUI_CONTROL_H
