//////////////////////////////////////////////////////////////////////////////
// Name:        SVGUINoteBook.h
// Purpose:     
// Author:      Laurent Bessard
// Created:     2005/09/08
// RCS-ID:      $Id: SVGUINoteBook.h,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#ifndef SVGUI_NOTEBOOK_H
#define SVGUI_NOTEBOOK_H

#include "SVGUIControl.h"
#include <math.h>
#include <wxSVG/svg.h>
#include <wx/string.h>
#include <wxSVG/SVGElement.h>
#include <wxSVG/CSSValue.h>
#include <wx/wx.h>
#include <wx/xrc/xmlres.h>

class SVGUINoteBook:
	public SVGUIControl
{
	protected:
		unsigned int m_current_page;
		wxSVGElement* m_GroupElement;
		wxSVGElement* m_Page0Element;
		wxSVGElement* m_Page1Element;
		wxSVGElement* m_ContentElement;
		wxWindow* m_Page0Content;
		wxWindow* m_Page1Content;
	
	public:
		SVGUINoteBook(wxSVGDocument* doc, wxEvtHandler* window);
		
		bool HitTest(wxPoint pt);
		wxSVGRect GetBBox();
		bool SetAttribute(const wxString& attrName, const wxString& attrValue);
		void Update_Elements();
		void RefreshContentSize(double scale);
		
		void OnLeftDown(wxMouseEvent &event);
		void OnMotion(wxMouseEvent& event);
		void OnLeftUp(wxMouseEvent& event);
};

#endif //SVGUI_NOTEBOOK_H
