/*
 * Cache module header
 * Cache holds [key-value] pairs.
 * Both key and value are strings.
 * Cache makes copies of key and value and holds them.
 * Every interface accepts lenb(length in byte)==0, and in that case, string should be
 * null-byte terminated.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __XYAKU_CACHE_H__
#define __XYAKU_CACHE_H__

/* Forward declarations of types. */
typedef struct _XyCache XyCache;/* "Xy" is "xyaku"'s "xy". No deep meaning.*/

extern XyCache* cache_new(int ini_size);
extern void cache_destroy(XyCache *cache);
extern int cache_insert(XyCache *cache, const char *key, int key_lenb, const char *value, int value_lenb);
extern int cache_remove(XyCache *cache, const char *key, int key_lenb);
extern const char* cache_lookup(XyCache *cache, const char *key, int key_lenb);


#endif /* __XYAKU_CACHE_H__ */

