#ifndef _H_EUREKA_PAGE
#define _H_EUREKA_PAGE

#include <kurl.h>
#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <QWidget>
#include <QList>
#include <kfileitem.h>

class Page : public QWidget
{
    Q_OBJECT
public:
    Page( const KUrl& url = KUrl( "about:blank" ), const KParts::OpenUrlArguments& arguments = KParts::OpenUrlArguments(), const KParts::BrowserArguments& browserArguments = KParts::BrowserArguments(), QWidget* parent = 0 );
    inline QString title() { return ptitle; }
    inline QString status() { return pstatus; }
    inline QString mimetype() { return pmimetype; }
    inline KUrl url() { return purl; }
    inline QList<KUrl> history() { return phistory; }
    inline QList<KUrl> future() { return pfuture; }

public slots:
    void goTo( const KUrl& url, const KParts::OpenUrlArguments& arguments= KParts::OpenUrlArguments(), const KParts::BrowserArguments& browserArguments = KParts::BrowserArguments() );
    void back();
    void reload();
    void forward();
    inline void stop() { part->closeUrl(); }

signals:
    void newTitle( const QString& );
    void newStatus( const QString& );
    void newUrl( const KUrl& );
    void newLocation( const QString& );
    void newTab( const KUrl &, const KParts::OpenUrlArguments, KParts::BrowserArguments );
    void newWindow( const KUrl & );
    void newProgress( int );
    void loading( bool );

private slots:
    KParts::ReadOnlyPart* partFactory( const KUrl& url, const KParts::OpenUrlArguments& arguments= KParts::OpenUrlArguments() );
    void setTitle( const QString& snewTitle );
    void setStatus( const QString& snewStatus );
    void setLocation( const QString& snewLocation );
    void setUrl( const KUrl& snewUrl );
    void popupMenu( const QPoint &global, const KUrl &url, mode_t mode, const KParts::OpenUrlArguments &args, const KParts::BrowserArguments& browserArgs, KParts::BrowserExtension::PopupFlags flags, const KParts::BrowserExtension::ActionGroupMap& actionGroups );
    void popupMenu( const QPoint &global, const KFileItemList &items, const KParts::OpenUrlArguments &args, const KParts::BrowserArguments& browserArgs, KParts::BrowserExtension::PopupFlags itemFlags, const KParts::BrowserExtension::ActionGroupMap& _actionGroups );
    inline void doneLoading() { emit loading( false ); }
    inline void startLoading( KIO::Job* ) { emit loading( true ); }

private:
    QString ptitle;
    QString pstatus;
    QString pmimetype;
    KUrl purl;
    KParts::ReadOnlyPart* part;
    QList<KUrl> phistory;
    QList<KUrl> pfuture;
};

#endif

