#include "tagdialog.h"
#include <KAction>
#include <kurl.h>
#include <nepomuk/tag.h>
#include <nepomuk/kmetadatatagwidget.h>
#include <nepomuk/variant.h>
#include <klocale.h>

TagDialog::TagDialog( const KUrl& url, const QString& title, QWidget* parent ) : KDialog( parent )
{
    Nepomuk::Resource res( url );
    res.setLabel( title );
    res.addIdentifier( title );
    setCaption( i18n( "Tag this page" ) );
    setButtons( KDialog::Ok );
    Nepomuk::TagWidget* tw = new Nepomuk::TagWidget( res, this );
    setMainWidget( tw );
}

