#ifndef _H_EUREKA_URLACTION
#define _H_EUREKA_URLACTION

#include <kurl.h>
#include <KAction>
#include <kparts/browserextension.h>

class UrlAction : public KAction
{
    Q_OBJECT
public:
    UrlAction( const QString& text, QObject* parent = 0, const KUrl& url = KUrl( "about:blank" ), const KParts::OpenUrlArguments& arguments = KParts::OpenUrlArguments(), const KParts::BrowserArguments& browserArguments = KParts::BrowserArguments() );
public slots:
    inline void setUrl( const QString& uri ) { murl = KUrl( uri ); }
    inline void setUrl( const KUrl& url ) { murl = url; }
signals:
    void triggered( KUrl, KParts::OpenUrlArguments, KParts::BrowserArguments );
private slots:
    inline void emitUrl() { emit triggered(  murl, marguments, mbrowserArguments ); }
private:
    KUrl murl;
    KParts::OpenUrlArguments marguments;
    KParts::BrowserArguments mbrowserArguments;
};

#endif

