/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef PASSWORD_H
#define PASSWORD_H

//KDE
#include <kassistantdialog.h>

//Ui
#include "ui_password_assistant_intro.h"
#include "ui_password_assistant_step1.h"
#include "ui_password_assistant_step2.h"
#include "ui_password_assistant_step3.h"
#include "ui_password_assistant_summary.h"

//KGRUBEditor
#include "core/datatypes.h"

const QString encryptCommand( "grub-md5-crypt" );

/**
 * @short Password Assistant.
 *
 * Creates / edits GRUB passwords step-to-step.
 */
class PasswordAssistant : public KAssistantDialog
{
Q_OBJECT
public:
	/**
	* Sets up the GUI and shows the password.
	*
	* @param password The password to create/edit.
	* @param parent QWidget parent. Self explanatory.
	*/
	PasswordAssistant( GRUB::ComplexCommand::Password *password, QWidget *parent = 0 );
	/**
	* Desctructor.
	*/
	~PasswordAssistant();
private:
	/**
	* Connects all signals to their slots.
	*/
	void setupConnections();
private slots:
	/**
	* Checks whether the password field is empty
	* and if not, it allows the user to procede.
	*
	* Since entering a password (at least) is mandatory this
	* process is necessary. To find out why a password is needed
	* see here:
	* @see GRUB::ComplexCommand::Password
	*/
	void setPasswordPageValid( const QString &text );
	/**
	* Encrypts password using MD5 and shows it to the password field.
	*
	* Uses the grub-md5-crypt tool provided by GRUB.
	*/
	void encryptPassword();
	/**
	* Before accessing the last page, it collects all data
	* that where entered by the user and creates a summary.
	*/
	void nextClicked();
	/**
	* If the Finish button is pressed, finalises all changes
	* done to the password.
	*/
	void finishClicked();
private:
	Ui::password_assistant_intro ui_intro;
	Ui::password_assistant_step1 ui_step1;
	Ui::password_assistant_step2 ui_step2;
	Ui::password_assistant_step3 ui_step3;
	Ui::password_assistant_summary ui_summary;

	KPageWidgetItem *passwordPage;
	KPageWidgetItem *summaryPage;

	GRUB::ComplexCommand::Password *m_password;
};

#endif
