'''OpenGL extension SGIS.texture_select

Overview (from the spec)
	
	This extension introduces several new texture internal formats.  The
	purpose of these new formats is to reorganize the components of a
	texture into groups of components.  The currently selected group
	effectively becomes the internal format.
	
	Also, two new texture parameters are introduced that control the
	selection of these groups of components.
	
	For example, assume a texture internal format of DUAL_LUMINANCE4_SGIS is
	specified.  Now there are two groups of components, where each group has
	a format of LUMINANCE4.  One of the two LUMINANCE groups is always
	selected.  components can be selected and then interpreted as a LUMINANCE
	texture.
	
	The purpose of this extension is allow better utilization of texture
	memory by subdividing the internal representation of a texel into 1, 2,
	or 4 smaller texels.  Additionally, this may improve performance of
	texture downloads.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGIS/texture_select.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_DUAL_ALPHA4_SGIS = constant.Constant( 'GL_DUAL_ALPHA4_SGIS', 0x8110 )
GL_DUAL_ALPHA8_SGIS = constant.Constant( 'GL_DUAL_ALPHA8_SGIS', 0x8111 )
GL_DUAL_ALPHA12_SGIS = constant.Constant( 'GL_DUAL_ALPHA12_SGIS', 0x8112 )
GL_DUAL_ALPHA16_SGIS = constant.Constant( 'GL_DUAL_ALPHA16_SGIS', 0x8113 )
GL_DUAL_LUMINANCE4_SGIS = constant.Constant( 'GL_DUAL_LUMINANCE4_SGIS', 0x8114 )
GL_DUAL_LUMINANCE8_SGIS = constant.Constant( 'GL_DUAL_LUMINANCE8_SGIS', 0x8115 )
GL_DUAL_LUMINANCE12_SGIS = constant.Constant( 'GL_DUAL_LUMINANCE12_SGIS', 0x8116 )
GL_DUAL_LUMINANCE16_SGIS = constant.Constant( 'GL_DUAL_LUMINANCE16_SGIS', 0x8117 )
GL_DUAL_INTENSITY4_SGIS = constant.Constant( 'GL_DUAL_INTENSITY4_SGIS', 0x8118 )
GL_DUAL_INTENSITY8_SGIS = constant.Constant( 'GL_DUAL_INTENSITY8_SGIS', 0x8119 )
GL_DUAL_INTENSITY12_SGIS = constant.Constant( 'GL_DUAL_INTENSITY12_SGIS', 0x811A )
GL_DUAL_INTENSITY16_SGIS = constant.Constant( 'GL_DUAL_INTENSITY16_SGIS', 0x811B )
GL_DUAL_LUMINANCE_ALPHA4_SGIS = constant.Constant( 'GL_DUAL_LUMINANCE_ALPHA4_SGIS', 0x811C )
GL_DUAL_LUMINANCE_ALPHA8_SGIS = constant.Constant( 'GL_DUAL_LUMINANCE_ALPHA8_SGIS', 0x811D )
GL_QUAD_ALPHA4_SGIS = constant.Constant( 'GL_QUAD_ALPHA4_SGIS', 0x811E )
GL_QUAD_ALPHA8_SGIS = constant.Constant( 'GL_QUAD_ALPHA8_SGIS', 0x811F )
GL_QUAD_LUMINANCE4_SGIS = constant.Constant( 'GL_QUAD_LUMINANCE4_SGIS', 0x8120 )
GL_QUAD_LUMINANCE8_SGIS = constant.Constant( 'GL_QUAD_LUMINANCE8_SGIS', 0x8121 )
GL_QUAD_INTENSITY4_SGIS = constant.Constant( 'GL_QUAD_INTENSITY4_SGIS', 0x8122 )
GL_QUAD_INTENSITY8_SGIS = constant.Constant( 'GL_QUAD_INTENSITY8_SGIS', 0x8123 )
GL_DUAL_TEXTURE_SELECT_SGIS = constant.Constant( 'GL_DUAL_TEXTURE_SELECT_SGIS', 0x8124 )
GL_QUAD_TEXTURE_SELECT_SGIS = constant.Constant( 'GL_QUAD_TEXTURE_SELECT_SGIS', 0x8125 )


def glInitTextureSelectSGIS():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_SGIS_texture_select' )
