#!/usr/bin/perl
use strict;
use lib 'blib/lib';
use lib 'blib/arch';
use Rast;
use POSIX;

if (@ARGV ne 2) {
    print "usage: $0 <dbpath> <file path>\n";
    exit;
}

my $dbpath = @ARGV[0];
my $path = @ARGV[1];

die "dbpath is not found.\n"
    unless -e $dbpath || $dbpath =~ m|^xmlrpc.https?://|io;

die "$path is not found.\n"
    unless -e $path;

open(FILE, "$path");
my $text = join("", <FILE>);
close(FILE);

my $db = Rast->open($dbpath, RAST_DB_RDWR);

my $result = $db->search("filename = $path",{
 need_summary => 1,
 properties => ["last_modified"]
});
die "search error\n"
    unless $result;

my @stat = stat($path);
my $last_modified = POSIX::strftime("%Y-%m-%dT%H:%M:%S", localtime($stat[9]));

my $options = [$path, $path, $last_modified, length($text)];
my $new_id;

if ($result->hit_count) {
    my $row = $result->fetch;

    if ($last_modified ne $row->{properties}->[0]) {
	print "old mtime: " . $row->{properties}->[0] . "\n";
	print "now mtime: " . $last_modified . "\n";
	$new_id = $db->update($text,$options, $row->{doc_id});
	print "update: old docid = " . $row->{doc_id} . " to new docid: $new_id\n";
    }
} else {
    $new_id = $db->register($text,$options);
    print "add new docid: $new_id\n";
}
$db->close();

exit;
