#!/usr/bin/perl
use strict;
use lib 'blib/lib';
use lib 'blib/arch';
use Rast;

if (@ARGV ne 2) {
    print "usage: $0 <dbpath> <query>\n";
    exit;
}

my $dbpath = @ARGV[0];
my $query = @ARGV[1];

die "dbpath is not found.\n"
    unless -e $dbpath || $dbpath =~ m|^xmlrpc.https?://|io;

die "$query is not found.\n"
    unless $query;

my $db = Rast->open($dbpath);

my $result = $db->search($query,{
 need_summary => 1,
 properties => ["title", "filename", "last_modified", "filesize"]
});

die "search error\n"
    unless $result;

print "Query: $query\n";
print "Hit  : " . $result->hit_count . "\n";
while (my $row = $result->fetch) {
    print "
doc_id: " . $row->{doc_id} . "
score: " . $row->{score} . "
filename: " . $row->{properties}->[1] . "
title: " . $row->{properties}->[0] . "
last_modified: " . $row->{properties}->[2] . "
filesize: " . $row->{properties}->[3] . "
summary:
$row->{summary}
---------------------------------------------
";
}
$db->close();

exit;
