# $Id: courier-imap.spec.in,v 1.83 2008/08/24 20:11:36 mrsam Exp $
#
# Copyright 1998 - 2008 Double Precision, Inc.  See COPYING for
# distribution information.
#
#  Need to version-upgrade RH builds due to different directory locations.
#

%define is_not_mandrake %(test ! -e /etc/mandrake-release && echo 1 || echo 0)
# check if SuSE is installed. If not, set a dummy suse_version to null, else use the given value from SuSE.
%if ! %([ -e /etc/SuSE-release ] && echo 1 || echo 0)
%define suse_version 0
%endif

%if %suse_version
%define courier_release .suse%{suse_version}
%else
%if %is_not_mandrake
%define courier_release %(release="`rpm -q --queryformat='.%{VERSION}' redhat-release 2>/dev/null`" ; if test $? != 0 ; then release="`rpm -q --queryformat='.%{VERSION}' fedora-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; fi ; echo "$release")
%else
%define courier_release mdk
%endif
%endif

%define _missing_doc_files_terminate_build 1
%define _unpackaged_files_terminate_build 1

Summary: Courier-IMAP 4.5.0 IMAP server
Name: courier-imap
Version: 4.5.0
Release: 3%{courier_release}
License: GPL
Group: Applications/Mail
Source: %{name}-4.5.0.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Requires: /sbin/chkconfig fileutils textutils sh-utils sed
Requires: courier-authlib-devel >= 0.60.6.20080629
BuildPreReq: textutils fileutils perl
BuildPreReq: courier-authlib-devel >= 0.60.6.20080629

%define use_openssl %(rpm -q openssl-devel >/dev/null 2>&1 && echo 1 && exit 0; echo 0)

%if %use_openssl
BuildPreReq:      openssl
BuildPreReq:      openssl-devel
%else
BuildPreReq:      gnutls-devel /usr/bin/certtool
Requires:	  /usr/bin/certtool
%endif

Obsoletes: %{name}-ldap
Obsoletes: %{name}-mysql
Obsoletes: %{name}-pgsql

%if %suse_version
BuildPreReq: rpm >= 3.0.5 /usr/bin/sed %([ %{suse_version} -gt 819 ] && echo /usr/include/fam.h)
%else
BuildPreReq: rpm >= 4.0.2 sed /usr/include/fam.h
%endif

#  RH 7.0 resets sysconfdir & mandir, put them back where they belong

%define _sysconfdir %{_prefix}/etc
%define	_mandir %{_prefix}/man

%define	_prefix	/usr/lib/courier-imap

%define _localstatedir /var/run

%define initdir %(if test -d /etc/init.d/. ; then echo /etc/init.d ; else echo /etc/rc.d/init.d ; fi)

%define pamconfdir	/etc/pam.d
#
# SuSE specific settings
%if %suse_version
# some templates for SuSE distribs.
%define templdir	${RPM_BUILD_DIR}/%{name}-4.5.0/packaging/suse
%define _sysconfdir	/etc/courier-imap
%define	_mandir		/usr/share/man
%define initlndir	/usr/sbin
%endif

%description
Courier-IMAP is an IMAP server for Maildir mailboxes.  This package contains
the standalone version of the IMAP server that's included in the Courier
mail server package.  This package is a standalone version for use with
other mail servers.  Do not install this package if you intend to install the
full Courier mail server.  Install the Courier package instead.

%prep

%setup -q

%if %(test '%{xflags}' = '%%{xflags}' && echo 1 || echo 0)
%define xflags --enable-unicode=iso-8859-1,utf-8
%endif

%configure \
	--with-redhat \
	%{?xflags: %{xflags}}

%build
%{__make} %{_smp_mflags}
%{__make} check

%install

%{__rm} -rf $RPM_BUILD_ROOT
%{__mkdir_p} $RPM_BUILD_ROOT%{pamconfdir}
%{__mkdir_p} $RPM_BUILD_ROOT%{initdir}
%{__make} install DESTDIR=$RPM_BUILD_ROOT

#
# Red Hat or SuSE like init.d file.
%if %suse_version
# Create SuSE courier-imap start script and a link in /usr/sbin
%{__mkdir_p} ${RPM_BUILD_ROOT}%{initlndir}
install -Dm 744 %{templdir}/courier-imap.init ${RPM_BUILD_ROOT}/%{initdir}/courier-imap && \
ln -sf %{initdir}/courier-imap ${RPM_BUILD_ROOT}%{initlndir}/rccourier-imap \
#
# Fix for SuSE like pam file look.
install -Dm 644 %{templdir}/pop3.pam $RPM_BUILD_ROOT%{pamconfdir}/pop3
install -Dm 644 %{templdir}/imap.pam $RPM_BUILD_ROOT%{pamconfdir}/imap
%else
# Copy standard sysvinit file
install -Dm 744 courier-imap.sysvinit $RPM_BUILD_ROOT/%{initdir}/courier-imap
%endif

#
# Fix imapd.dist
#

%{__sed} 's/^IMAPDSTART=.*/IMAPDSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist \
	>$RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist.tmp

%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist

%{__sed} 's/^IMAPDSSLSTART=.*/IMAPDSSLSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist \
	>$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist.tmp

%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist

%{__chmod} 600 $RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist
%{__chmod} 600 $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist

%{__sed} 's/^POP3DSTART=.*/POP3DSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist \
	>$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist.tmp

%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist

%{__sed} 's/^POP3DSSLSTART=.*/POP3DSSLSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist \
	>$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist.tmp

%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist

%{__chmod} 600 $RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist
%{__chmod} 600 $RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist

#
# Red Hat /etc/profile.d scripts
#

%{__mkdir_p} $RPM_BUILD_ROOT/etc/profile.d
%{__cat} >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.sh <<EOF
if echo "\$MANPATH" | tr ':' '\012' | fgrep -qx %{_mandir}
then
	:
else
	MANPATH="%{_mandir}:\$MANPATH"
	export MANPATH
	PATH="%{_bindir}:\$PATH"
	if test -w /etc
	then
		PATH="%{_sbindir}:\$PATH"
	fi
	export PATH
fi
EOF

%{__cat} >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.csh <<EOF

if ( \$?MANPATH ) then
	true
else
	setenv MANPATH ""
endif

echo "\$MANPATH" | tr ':' '\012' | fgrep -qx %{_mandir}

if ( \$? ) then
	true
else
	setenv MANPATH "%{_mandir}:\$MANPATH"
	setenv PATH "%{_bindir}:\$PATH"
	test -w /etc
	if ( \$? ) then
		true
	else
		setenv PATH "%{_sbindir}:\$PATH"
	endif
endif
EOF

%{__cp} imap/README README.imap
%{__cp} imap/README.proxy* .
%{__cp} maildir/README.maildirquota.txt README.maildirquota
%{__cp} maildir/README.sharedfolders.txt README.sharedfolders

####
## Create config files for sysconftool-rpmupgrade (see below)

%{__mkdir_p} $RPM_BUILD_ROOT%{_datadir}
%{__cp} -f sysconftool $RPM_BUILD_ROOT%{_datadir}/sysconftool
%{__chmod} 555 $RPM_BUILD_ROOT%{_datadir}/sysconftool
%{__cat} >$RPM_BUILD_ROOT%{_datadir}/configlist <<EOF
%{_sysconfdir}/imapd.dist
%{_sysconfdir}/imapd-ssl.dist
%{_sysconfdir}/pop3d.dist
%{_sysconfdir}/pop3d-ssl.dist
EOF

%{__chmod} 644 $RPM_BUILD_ROOT%{_datadir}/configlist*

######
##
## Ok, upgrades are going to get ugly.  Because we install $filename.dist
## instead of $filename, and the old package has $filename listed as a config,
## RPM will back up $filename to $filename.rpmsave.  This will happen AFTER
## we will run the post scripts, effectively blowing away our configurations.
## PUT THEM BACK BY RUNNING THE FOLLOWING SCRIPT FROM A TRIGGER.

%{__cat} >$RPM_BUILD_ROOT%{_datadir}/sysconftool-rpmupgrade <<EOF
#!/bin/sh

for f in \$* "."
do
	if test \$f = "."
	then
		continue
	fi

	base=\`echo \$f | sed 's/\\.dist\$//'\`
	if test -f \$base.dist -a ! -f \$base
	then
		%{__cp} -pr \$base.dist \$base
	fi
done
EOF

%{__chmod} 555 $RPM_BUILD_ROOT%{_datadir}/sysconftool-rpmupgrade

%{__mkdir_p} $RPM_BUILD_ROOT%{_localstatedir}
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd-ssl.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd.pid.lock
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd-ssl.pid.lock

touch $RPM_BUILD_ROOT%{_localstatedir}/pop3d.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/pop3d-ssl.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/pop3d.pid.lock
touch $RPM_BUILD_ROOT%{_localstatedir}/pop3d-ssl.pid.lock

%post
/sbin/chkconfig --del courier-imap
/sbin/chkconfig --add courier-imap
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist` >/dev/null

%preun

if test "$1" = "0"
then
	rm -f %{_localstatedir}/couriersslcache
	/sbin/chkconfig --del courier-imap
fi

%{_libexecdir}/imapd.rc stop
%{_libexecdir}/imapd-ssl.rc stop
%{_libexecdir}/pop3d.rc stop
%{_libexecdir}/pop3d-ssl.rc stop

%triggerpostun -- courier-imap

test ! -f %{_datadir}/configlist || %{_datadir}/sysconftool-rpmupgrade `%{__cat} %{_datadir}/configlist` >/dev/null

%files
%defattr(-, bin, bin)
%attr(644, root, root) %config(noreplace) %{pamconfdir}/imap
%attr(644, root, root) %config(noreplace) %{pamconfdir}/pop3

%attr(755, bin, bin) %config /etc/profile.d/courier-imap.csh
%attr(755, bin, bin) %config /etc/profile.d/courier-imap.sh
%attr(755, bin, bin) %{initdir}/courier-imap
%if %{suse_version}
%attr(740,root,root) %{initlndir}/rccourier-imap
%endif
%dir %{_prefix}

%if "%{_prefix}" != "%{_exec_prefix}"
%dir %{_exec_prefix}
%endif

%{_libexecdir}
%dir %{_sysconfdir}
%dir %{_sysconfdir}/shared
%dir %{_sysconfdir}/shared.tmp

%config %{_sysconfdir}/imap*
%config %{_sysconfdir}/pop3*
%config %{_sysconfdir}/quotawarnmsg.example
%{_bindir}
%{_sbindir}
%{_mandir}
%{_datadir}

%doc NEWS AUTHORS COPYING imap/BUGS README README.imap README.maildirquota
%doc README.sharedfolders
%doc README.proxy*

%ghost %attr(600, root, root) %{_localstatedir}/imapd.pid
%ghost %attr(600, root, root) %{_localstatedir}/imapd-ssl.pid
%ghost %attr(600, root, root) %{_localstatedir}/imapd.pid.lock
%ghost %attr(600, root, root) %{_localstatedir}/imapd-ssl.pid.lock

%ghost %attr(600, root, root) %{_localstatedir}/pop3d.pid
%ghost %attr(600, root, root) %{_localstatedir}/pop3d-ssl.pid
%ghost %attr(600, root, root) %{_localstatedir}/pop3d.pid.lock
%ghost %attr(600, root, root) %{_localstatedir}/pop3d-ssl.pid.lock

%clean
rm -rf $RPM_BUILD_ROOT
