
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of www_int, software which returns an HTML form which
// can be used to build a URL to access data from a DAP data server.

// Copyright (c) 2002,2003 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

// (c) COPYRIGHT URI/MIT 1999
// Please read the full copyright statement in the file COPYRIGHT_URI.
//
// Authors:
//      jhrg,jimg       James Gallagher <jgallagher@gso.uri.edu>

// Implementation for WWWByte. See the comments in WWWByte.h
//
// 4/7/99 jhrg

#include "config.h"

static char rcsid[] not_used = {"$Id: WWWByte.cc 17641 2008-01-07 21:33:07Z jimg $"};

// The NewByte `helper function' creates a pointer to an WWWByte and
// returns that pointer. It takes the same arguments as the class's ctor. If
// any of the variable classes are subclassed (e.g., to make a new Byte like
// HDFByte) then the corresponding function here, and in the other class
// definition files, needs to be changed so that it creates an instnace of
// the new (sub)class. Continuing the earlier example, that would mean that
// NewByte() would return a HDFByte, not a Byte.
//
// It is important that these function's names and return types do not change
// - they are called by the parser code (for the dds, at least) so if their
// names changes, that will break.
//
// The declarations for these fuctions (in util.h) should *not* need
// changing. 

#include <stdio.h>

#include <iostream>
#include <string>

//#include "InternalErr.h"

#include "WWWByte.h"
#include "WWWOutput.h"
#include "get_html_form.h"

using namespace dap_html_form;

WWWByte::WWWByte(const string &n) : Byte(n)
{
}

BaseType *
WWWByte::ptr_duplicate()
{
    return new WWWByte(*this);
}

void 
WWWByte::print_val(FILE *os, string, bool /*print_decl_p*/)
{
    write_simple_variable(os, name(), fancy_typename(this));
}

void 
WWWByte::print_val(ostream &strm, string, bool /*print_decl_p*/)
{
    write_simple_variable(strm, name(), fancy_typename(this));
}

