// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __GUI_H__
#define __GUI_H__

#include "def.h"

#include <cstdio>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
// #include <gdk/gdkrgb.h>

#include "gaiji.h"
#include "honmon.h"

extern GtkWidget* mainWindow;
extern GtkWidget* mainBox;
extern GtkWidget* resultText;
extern GtkWidget* filew;
extern GtkWidget* wordBox;
extern GtkWidget* hiddenWordBox;
extern GtkWidget* resultScroll;
extern GtkWidget* hpaned;
extern GtkWidget* dicTitle;

extern GtkWidget *dictMenuBase1,*dictMenuBase2,*currentDictMenuBase;
extern GtkWidget *indexMenuBase1,*indexMenuBase2,*currentIndexMenuBase;
extern GtkWidget *currentDictMenu,*currentIndexMenu;

extern GtkAccelGroup* accelGroup;
extern GdkGC* gc;
extern GdkGC* gc_temp;
extern GdkGC* gc_color[32];
extern GdkGC* gc_red;
extern GdkGC* gc_blue;
extern GdkGC* gc_green;
extern GdkGC* gc_inv;
extern GdkGC* gc_red_inv;
extern GdkGC* gc_blue_inv;
extern GdkGC* gc_green_inv;
extern GtkItemFactory * ifact,*ifact2;
extern GdkFont *normalFont,*boldFont,*italicFont,*boldItalicFont,*scriptFont,*isoFont;

extern GAIJI* currentGaiji;

extern GtkWidget* MakePixmapFromDicText(const DICSTRING& str,bool em);
extern void ButtonInit(void);
void DisplayHonmon(const TAG& t);

extern int isClickableImage;
struct CLICKABLE_BOX {
  DICCHAR ch;
  int x;
  int y;
  int w;
  int h;
  GtkWidget* widget;
  CLICKABLE_BOX() : widget(NULL) { };
};

struct HISTORY {
  std::list<TAG> tag;
  std::list<TAG>::iterator currentPoint;
  void Append(const TAG& t);
  TAG Next();
  TAG Prev();
  TAG Last() const;
  void Initialize();
  HISTORY(){ Initialize(); };
};

extern HISTORY hist;

#include "buildwin.h"
#include "callback.h"

extern std::string FileDialog(std::string fileName,
			      std::string defaultFileName);

/*
struct DICT_PARAM {
  string path;
  string name;
  int charOffset;
  int gaijiOffset;
  int charExtend;
  bool autoImageDisplay;
};
*/

#define PP "/ebdic/preference/"

struct PREFERENCE {
  bool ClearDictionaryList();
  bool CreateDictionaryList();
  void *preference_private;

public:
  void* Private(){ return preference_private; };
  int currentDictNum; // for fast access

  PREFERENCE() { Reset(); };
  bool Reset();
  bool Read(const char* fileName=NULL);
  bool Write(const char* fileName=NULL);
  NATIVE_STRING GetStringValue(const char* path);
  bool GetBoolValue(const char* path);
  int GetIntValue(const char* path);
  bool SetStringValue(const char* path,const NATIVE_STRING& str);
  bool SetBoolValue(const char* path,bool b);
  bool SetIntValue(const char* path,int i);
};

extern PREFERENCE preference;

#endif
