/***************************************************************************
 *   Copyright (C) 2008 by Kitsune                                         *
 *   sutoka@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef COOKIEMONSTER_H
#define COOKIEMONSTER_H

#include <QNetworkCookieJar>
#include <QPointer>

const signed int NOPATHGIVEN = -4; // KStandardDirs didn't give us a path
const signed int TOONEW = -3;
const signed int WRONGMAGIC = -3;
const signed int FLUSHFAIL = -2;
const signed int OPENFAIL = -1;
const signed int ALLOKAY = 1;
const signed int EMPTYLIST = 2; // Generally not an error.
const signed int NOFILE = 3; // Could just be first run.
const signed int NOTTAINTED = 4;

const int VERSION_CURRENT = 0;
const int FK_ignore_compat = 0; //Qt_4_0 stream. Will break these streams oh so often.

const quint32 MAGICNUMBER = 0xD9D0A450; // Random 'magic' number. Just wrote stuff, so may not be unique :P

/**
	@author Kitsune <sutoka@gmail.com>
*/
class cookieMonster : public QNetworkCookieJar
{
        Q_OBJECT
public:
        cookieMonster(QObject * parent = 0);

        ~cookieMonster();

        QList<QNetworkCookie> getCookies()  { return allCookies(); }
        int getCookieSaveInterval()         { return s_cookieSaveInterval; }
        void setCookieSaveInterval(int saveInterval)     { s_cookieSaveInterval = saveInterval; }

        virtual QList<QNetworkCookie> cookiesForUrl( const QUrl & url ) const;
        virtual bool setCookiesFromUrl( const QList<QNetworkCookie> & cookieList, const QUrl & url );

public slots:
        signed int saveIfTainted();
        signed int writeToDisk();
        signed int loadFromDisk();

protected:
        void timerEvent(QTimerEvent *event);

private:
        int m_timerId;
        int s_cookieSaveInterval;
        bool m_tained;
        QPointer<cookieMonster> m_parentJar;
        bool m_mirrorParent;
        bool m_readOnly;
};

#endif
