/***************************************************************************
 *   Copyright (C) 2008 by Kitsune                                         *
 *   sutoka@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <KApplication>
#include <KAboutData>
#include <KCmdLineArgs>
#include <QUrl>
#include "foxkit.h"
#include "wrapper.h"

int main(int argc, char *argv[])
{
        KAboutData aboutData(
                // The program name used internally.
                "foxkit",
                // The message catalog name
                // If null, program name is used instead.
                0,
                // A displayable program name string.
                ki18n("Foxkit"),
                // The program version string.
                "0.3-git",
                // Short description of what the app does.
                ki18n("A webkit based browser."),
                // The license this code is released under
                KAboutData::License_GPL,
                // Copyright Statement
                ki18n("(c) 2008"),
                // Optional text shown in the About box.
                // Can contain any information desired.
                ki18n("Foxkit is a webbrowser based off of KDE4, Qt4, and Webkit"),
                // The program homepage string.
                "http://www.piratenetworks.net/",
                // The bug report email address
                "sutoka@gmail.com");
        KCmdLineArgs::init( argc, argv, &aboutData );

        KCmdLineOptions options;

        //TODO make this work
        options.add("+URL", ki18n("Location to open"));
        KCmdLineArgs::addCmdLineOptions( options );

        KApplication app;
        app.setApplicationName("Foxkit");
        app.setOrganizationName("KitsuneTech");
        app.setOrganizationDomain("piratenetworks.net");
        wrapper *main = new wrapper();
        Q_UNUSED(main);

        return app.exec();
}

