/***************************************************************************
 *   Copyright (C) 2008 by Kitsune                                         *
 *   sutoka@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "netmanager.h"

#include <iostream>
#include <QSslError>
#include <QNetworkReply>
#include <KMessageBox>

NetManager::NetManager(QObject * parent) : QNetworkAccessManager(parent), jar(this)
{
        setObjectName("NetManager:" + QString::number(uint(this)));
        std::cout << "CREATE:NetManager," << uint(this) << ";parent:" << uint(parent) << std::endl;
        setCookieJar(&jar);
        connect(this, SIGNAL(sslErrors(QNetworkReply*, const QList< QSslError > &)), this, SLOT(notifyOnSslError(QNetworkReply*, const QList< QSslError > &)));
}


NetManager::~NetManager()
{
        std::cout << "DESTROY:NetManager," << uint(this) << ";parent:" << uint(parent()) << std::endl;
}

/*QNetworkReply* NetManager::createRequest ( Operation op, const QNetworkRequest & req, QIODevice * outgoingData = 0 )
{
        //
}*/

cookieMonster * NetManager::cookieJar()
{
        return &jar;
}

void NetManager::notifyOnSslError(QNetworkReply * reply, const QList< QSslError > & errors)
{
        KMessageBox warning;
        QStringList errorList;
        for(int i = 0; i < errors.count(); i++)
        {
                errorList << errors.at(i).errorString();
        }
        int answer;
        QString address(reply->url().toString());
        address.replace("<", "&lt;");
        address.replace(">", "&gt;"); //Does this prevent parsing of any/all html tags?
        answer = warning.warningContinueCancelList(0, QString("The following SSL errors were encountered while trying to load the address \"<i>%1\"</i>.").arg(address), errorList, "Server Authentication Error - Foxkit Web Browser");
        if(answer == 5) // Continue was pressed
        {   //TODO Also save to a list so this same exact error won't be presented again this session.
                reply->ignoreSslErrors();
                return;
        }
}
