/***************************************************************************
 *   Copyright (C) 2008 by Sutoka   *
 *   sutoka@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "wrapper.h"
#include "foxkit.h"

#include <QUrl>
#include <iostream>
#include <KApplication>
#include <QWebSettings>
#include <QDir>
#include <kstandarddirs.h>

/*!
        This class wraps around the 'foxkit' class to allow multiple main windows.
        This should sit between main.cpp and foxkit.cpp, watch for a signal from foxkit
        asking for a new window (with/without a target page) to create a new instance.

        A list should also be created to contain all the windows for foxkit, and when that
        list is empty to quit.

        Wrapper should also watch for a signal requesting the configuration dialog be opened.
        When changes are saved all the instances of foxkit should be informed so they'll be
        able to update their settings.
*/
wrapper::wrapper() : QObject(), netman(this)
{
        setObjectName("wrapper:" + QString::number(uint(this)));
        connect(kapp, SIGNAL(lastWindowClosed()),
            this, SLOT(cleanUpAndQuit()));
        QString iconPath = KStandardDirs::locateLocal("cache", "foxkit");
        bool iconFailure = false;
        QDir tester(iconPath);
        if(!tester.exists(iconPath))
        {
                if(!tester.mkpath( iconPath ))
                {
                        std::cout << "FAILURE:setWebIconPath,cantMakeDir" << std::endl;
                        iconFailure = true;
                }
        }
        if(!iconFailure)
                QWebSettings::globalSettings()->setIconDatabasePath(iconPath);

        std::cout << "CREATE:wrapper," << uint(this) << ";parent:" << uint(parent()) << std::endl;
        newFoxkit(QNetworkRequest(foxkit::getHome()));
}


wrapper::~wrapper()
{
        std::cout << "DESTROY:wrapper," << uint(this) << ";parent:" << uint(parent()) << std::endl;
        std::cout << std::flush;
}

void wrapper::newFoxkit(QNetworkRequest request)
{
        foxkit * win = new foxkit(&netman);
            connect(win, SIGNAL(newWindow()),
                this, SLOT(newFoxkit()));
            connect(win, SIGNAL(newWindow(QNetworkRequest)),
                this, SLOT(newFoxkit(QNetworkRequest)));
            win->newView(false, request); //NEVER set this to true... NEVER!
            win->show();
}

void wrapper::cleanUpAndQuit()
{
        std::cout << "ACTION:cleanUpAndQuit" << std::endl;
        netman.cookieJar()->saveIfTainted();
        deleteLater();
}

