/**
 * @file main.c Main Galago Daemon file.
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <getopt.h>
#include "galagod.h"
#include "logging.h"

static struct option long_options[] =
{
	{ "log",     required_argument, NULL, 'l' },
	{ "verbose", no_argument,       NULL, 'v' },
	{ "help",    no_argument,       NULL, 'h' },
	{ NULL, 0, NULL, 0 }
};

static void
show_help(void)
{
	printf("usage: galago-daemon [OPTION]...\n"
		   "\n"
		   "  -v, --verbose            - Display verbose output\n"
		   "  -l, --log=filename       - Log to filename\n"
		   "  -h, --help               - Display this help screen\n");
}

int
main(int argc, char **argv)
{
	for (;;)
	{
		int c, option_index = 0;
		const char *opt;

		c = getopt_long(argc, argv, "hvl:", long_options, &option_index);

		if (c == -1)
			break;

		switch (c)
		{
			case 'h':
				opt = long_options[option_index].name;
				show_help();
				exit(EXIT_SUCCESS);
				break;

			case 'v':
				galagod_logging_set_verbose(TRUE);
				break;

			case 'l':
				galagod_logging_set_filename(optarg);
				break;

			default:
				show_help();
				exit(EXIT_FAILURE);
				break;
		}
	}

	galagod_logging_start();
	galagod_init();
	galagod_launch_feeds();

	g_main_loop_run(galagod_get_main_loop());

	galagod_uninit();

	return 0;
}
