/***************************************************************************
 *   Copyright (C) 2004 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ROMKAN_H
#define ROMKAN_H

#define Uses_SCIM_ICONV
#define Uses_SCIM_CONFIG_BASE
#include <vector>
#include <set>
#include <map>
#include <scim.h>
#include <scim_iconv.h>
#include <scim_event.h>
#include <honokamultiplepluginbase.h>
#include <preeditor.h>
#include <honokasetupcore.h>


#define HONOKA_CONFIG_ROMKAN_TABLE_FILE            "/IMEngine/Honoka/Romkan/TableFile"
#define HONOKA_DEFAULT_ROMKAN_TABLE_FILE           "honoka-def.rkt"
#define HONOKA_CONFIG_ROMKAN_A2K_KEY               "/IMEngine/Honoka/Romkan/AsciiToKana"
#define HONOKA_DEFAULT_ROMKAN_A2K_KEY              "Hiragana_Katakana"
#define HONOKA_CONFIG_ROMKAN_AUTO_A2K              "/IMEngine/Honoka/Romkan/AutoA2K"
#define HONOKA_DEFAULT_ROMKAN_AUTO_A2K             false


using namespace std;
using namespace scim;
/**
@author TAM(Teppei Tamra)
*/
namespace Honoka {

struct RomkanTableEntry {
    String key;
    WideString kana;
};

class RomkanKeyEventList : public HonokaKeyEventList
{
public:
    WideString p;
};

class Romkan;
class RomkanPlugin : public HonokaMultiplePluginBase {
public:
    RomkanPlugin(ConfigPointer cfg);

    ~RomkanPlugin();
    virtual HonokaPluginBase * getPluginInstanceAt(int p);
    virtual int getPluginCount();
    virtual String getName();
    static HonokaSetupCorePage *setup();

protected:
    vector<Romkan *> romkans;
};


class Romkan : public PreEditor {
public:
    Romkan(ConfigPointer cfg,String _postfix);

    ~Romkan();
    virtual void clear();
    virtual void setPos(int p);
    virtual void reset();
    virtual WideString getText(bool hosei = false);
    virtual void backspace();
    virtual void del();
    virtual void hiraKata();
    virtual void kataHira();
    virtual void toWide();
    virtual void toHalf();
    virtual bool keyEventHook(const KeyEvent &key);
    virtual String getModeName();
    virtual bool cancelEvent();
    virtual bool inputEvent(const KeyEvent &key);
    virtual String getName();
    virtual String getPropertyName();
    virtual void setText(const WideString &t);
    virtual AttributeList getAttributeList();

protected:
    WideString eval();
    WideString insert(char k);
    void init();
    void loadTable(const String &filename, bool inc = false);
    bool string2bool(const String &s);
    void asciiToKana();
    virtual void selected();

protected:
    String buf;
    String rmChars;
    String modeName;
    enum inputMode {ROMA,HROMA,KROMA,ASCII,WASCII};
    inputMode mode;
    bool nnMode;
    bool nProc;
    bool xtProc;
    bool asciiCancel;
    bool removeRemainder;
    HonokaKeyEventList key_ascii_mode,key_wascii_mode,key_toggle_hw,key_toggle_hk,key_a2k;
    map<String,WideString> RomkanTable;
    set<String> keepTable;
    map<String,String> tableConfig;
    String hookp;
    vector<RomkanKeyEventList> hookKey;
    String postfix;
    bool aa2k;
};

}

#endif
