/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SKKDIC_H
#define SKKDIC_H

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <map>
#include <scim.h>
#include <scim_iconv.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>

#define Uses_SCIM_UTILITY
#define Uses_SCIM_ICONV

using namespace std;
using namespace scim;


/**
@author TAM (Teppei Tamra)
*/
namespace Honoka {
class SKKDicEntryData {
public:
    WideString annotation;
    WideString kouho;
};

class SKKDicEntry {
public:
    vector<SKKDicEntryData> data;
    bool cache;
    bool okuri;
};

class SKKDic{
public:
    SKKDic(String file);

    ~SKKDic();
    const vector<SKKDicEntryData> find(WideString text);
    SKKDicEntryData annotationParser(WideString l);

protected:
    String filename;
    IConvert iconv;
    map<WideString,SKKDicEntry> dic_data;
    int fd;
    char *mmapptr;
    off_t mmapsize;
protected:
    void init();
    vector<WideString> parser(const WideString data);
};
}

#endif
