/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "mainwindow.h"
#include <kdetv_version.h>

int main(int argc, char **argv)
{
    static KCmdLineOptions options[] = {
        { 0, 0, 0 }
    };

    KAboutData about("kdetv", I18N_NOOP("kdetv"),
                     KDETV_VERSION,
                     I18N_NOOP("kdetv: TV for KDE"),
                     KAboutData::License_GPL,
                     I18N_NOOP("(c) 2002-2005 The kdetv Developers"), 0,
                     "http://www.kdetv.org/");
    about.addAuthor("Dirk Ziegelmeier",  I18N_NOOP("Developer and maintainer"),           "dziegel@gmx.de");
    about.addAuthor("George Staikos",    I18N_NOOP("Original author"),                    "staikos@kde.org");
    about.addAuthor("Richard Moore",     I18N_NOOP("GUI design, plugins"),                "rich@kde.org");
    about.addAuthor("Kevin Hessels",     I18N_NOOP("Configuration dialog"),               "khessels@shaw.ca");
    about.addAuthor("Stefan Hellwig",    I18N_NOOP("Webmaster, developer"),               "stefan@stefanhellwig.de");
    about.addAuthor("Zsolt Rizsanyi",    I18N_NOOP("Infrared remote support, developer"), "rizsanyi@users.sourceforge.net");
    about.addAuthor("Dawit Alemayehu",   I18N_NOOP("Developer"),                          "adawit@kde.org");
    about.addCredit("Bill Crowell",      I18N_NOOP("Donation of a DVB-C and DVB-T card"), "bill@crowellsystems.com");
    about.addCredit("Frank Pieczynski",  I18N_NOOP("Extensive testing"),                  "pieczy@web.de");
    about.addCredit("Koos Vriezen",      I18N_NOOP("V4L plugin fixes"),                   "koos.vriezen@xs4all.nl");
    about.addCredit("Andras Mantia",     I18N_NOOP("Ideas and fixes"),                    "amantia@kde.org");
    about.addCredit("Hans-Peter Jansen", I18N_NOOP("Ideas and fixes"),                    "hpj@urpla.net");

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication a;
//    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    MainWindow mw;
    mw.setCaption( i18n("kdetv") );

    a.setMainWidget( &mw );
    mw.show();

    int retval = a.exec();
    return retval;
}

