# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class BoardListWidget < Qt::Widget
  slots 'load_board_list()'
  slots 'search()'

  COLUMN_TITLE = 0

  def initialize(parent)
    super(parent)

    layout = Qt::VBoxLayout.new(self)

    @search_line = Qt::LineEdit.new(self)
    layout.addWidget(@search_line)
    connect(@search_line, SIGNAL("textChanged(const QString&)"), self, SLOT("search()"))

    @list = BoardListView.new(self)
    layout.addWidget(@list)
  end

  def load_board_list
    @list.load_board_list
  end

  def search
    str = @search_line.text
    regexp = Regexp.new(str, Regexp::IGNORECASE)

    (0...@list.topLevelItemCount).each {|i|
      categoryItem = @list.topLevelItem(i)
      matched = false
      (0...categoryItem.childCount).each {|j|
        boardItem = categoryItem.child(j)
        title = boardItem.text(0)

        if title.match(regexp) then
          boardItem.setHidden(false)
          matched = true
        else
          boardItem.setHidden(true)
        end
      }

      if (0...categoryItem.childCount).all? {|i|
        item = categoryItem.child(i)
        item.isHidden()
      } then categoryItem.setHidden(true)
     else
        categoryItem.setHidden(false)
      end
    }
  end
end
