# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class KitaHTMLPart < KDE::HTMLPart
  slots 'slotOnURL(const QString&)'
  slots 'write_res()', 'write_res_with_quote()'

  def initialize(parent)
    super
    connect(self, SIGNAL("onURL(const QString&)"), self, SLOT("slotOnURL(const QString&)"))
  end

  def set_view(view)
    @thread_view = view
  end

  def urlSelected(url, button, state, _target, args, browserArgs)
    if url[0..5] == "#write" then
      @num = url[6..-1].to_i

      popup = KDE::Menu.new
      popup.addAction("Write Res", self, SLOT('write_res()'))
      popup.addAction("Write Res with Quote", self, SLOT('write_res_with_quote()'))
      popup.exec(Qt::Cursor::pos())
    elsif url[0..3] == "#res" then
      num = url[4..-1].to_i
      gotoAnchor("res#{num}")
    else
      KDE::ToolInvocation.invokeBrowser(url)
    end
  end

  def write_res
    @thread_view.show_write_dialog_with_str(">>" + @num.to_s + "\n")
  end

  def write_res_with_quote
    res = @thread_view.body(@num)
    res = res.gsub(/(^|<br>)/, "\n> ")[1..-1]
    @thread_view.show_write_dialog_with_str(res)
  end

  def slotOnURL(url)
    if url && url[0..3] == "#res" then
      num = url[4..-1].to_i
      node = DOM::HTMLAnchorElement.new(nodeUnderMouse())
      plain = Util::to_plain(@thread_view.to_plain(num))
      node.setTitle(DOM::DOMString.new(plain))
    end
  end
end
