#!/usr/bin/perl
#
#  Extract values of xml elements xmlElement from all given xml files
#  and _append_ the messages to the catalog-file poFile.
#
use strict;
use POSIX qw(strftime);


sub usage #()
{
   print STDERR <<END
Usage: $0 xmlElement poFile file1.xml [file2.xml ...]

Extract values of xml elements xmlElement from all given xml files
and _append_ the messages to the catalog-file poFile.
END
;
   exit 1;
}


sub main #()
{
   usage() if ($#ARGV<2 || $ARGV[0] =~ /^-/);

   my $xmlElement = shift @ARGV;
   my $poFileName = shift @ARGV;
   my ($file, $lineno, $line);
   my $now = strftime("%Y-%m-%d %H:%M%z", localtime());

   open(OUT, ">>$poFileName") || die "$0: cannot write $poFileName: $!";
#
#    print OUT <<END
# # Automatically generated by $0
# # This is a temporary file that can be safely deleted
# #
# msgid ""
# msgstr ""
# "Project-Id-Version: PACKAGE VERSION\\n"
# "Report-Msgid-Bugs-To: \\n"
# "POT-Creation-Date: $now\\n"
# "PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n"
# "Last-Translator: FULL NAME <EMAIL\@ADDRESS>\\n"
# "Language-Team: LANGUAGE <LL\@li.org>\\n"
# "MIME-Version: 1.0\\n"
# "Content-Type: text/plain; charset=UTF-8\\n"
# "Content-Transfer-Encoding: 8bit\\n"
#
# END
#    ;

   open(IN, "grep -n '<$xmlElement' '".join("' '", @ARGV)."' |") ||
      die "$0: grep failed";

   while (<IN>)
   {
      chomp $_;
      ($file, $lineno, $line) = split(/:/, $_, 3);
      $line =~ s/^[^>]*>//;
      $line =~ s/<\/$xmlElement.*$//;

      print OUT "\n#: $file:$lineno\n";
      print OUT "msgid \"$line\"\n";
      print OUT "msgstr \"\"\n";
   }

   close(OUT);
}

&main;
