/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import logformat.clog2.Const;
import logformat.clog2.LineID;

public class Preamble {
    private static final int BYTESIZE = 1024;
    private static final int VERSIONSIZE = 12;
    private String version;
    private String is_big_endian_title;
    private boolean is_big_endian;
    private String is_finalized_title;
    private boolean is_finalized;
    private String block_size_title;
    private int block_size;
    private String num_blocks_title;
    private int num_blocks;
    private String max_world_size_title;
    private int max_world_size;
    private String max_thread_count_title;
    private int max_thread_count;
    private String known_eventID_start_title;
    private int known_eventID_start;
    private String user_eventID_start_title;
    private int user_eventID_start;
    private String known_solo_eventID_start_title;
    private int known_solo_eventID_start;
    private String user_solo_eventID_start_title;
    private int user_solo_eventID_start;
    private String known_stateID_count_title;
    private int known_stateID_count;
    private String user_stateID_count_title;
    private int user_stateID_count;
    private String known_solo_eventID_count_title;
    private int known_solo_eventID_count;
    private String user_solo_eventID_count_title;
    private int user_solo_eventID_count;
    private String commtable_fptr_title;
    private long commtable_fptr;

    public boolean readFromDataStream(DataInputStream dataInputStream) {
        byte[] byArray = new byte[1024];
        try {
            dataInputStream.readFully(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray), "\u0000");
        try {
            this.version = stringTokenizer.nextToken().trim();
            this.is_big_endian_title = stringTokenizer.nextToken().trim();
            String string = stringTokenizer.nextToken().trim();
            this.is_big_endian = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
            this.is_finalized_title = stringTokenizer.nextToken().trim();
            string = stringTokenizer.nextToken().trim();
            this.is_finalized = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
            this.block_size_title = stringTokenizer.nextToken().trim();
            this.block_size = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.num_blocks_title = stringTokenizer.nextToken().trim();
            this.num_blocks = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.max_world_size_title = stringTokenizer.nextToken().trim();
            this.max_world_size = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.max_thread_count_title = stringTokenizer.nextToken().trim();
            this.max_thread_count = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.known_eventID_start_title = stringTokenizer.nextToken().trim();
            this.known_eventID_start = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.user_eventID_start_title = stringTokenizer.nextToken().trim();
            this.user_eventID_start = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.known_solo_eventID_start_title = stringTokenizer.nextToken().trim();
            this.known_solo_eventID_start = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.user_solo_eventID_start_title = stringTokenizer.nextToken().trim();
            this.user_solo_eventID_start = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.known_stateID_count_title = stringTokenizer.nextToken().trim();
            this.known_stateID_count = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.user_stateID_count_title = stringTokenizer.nextToken().trim();
            this.user_stateID_count = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.known_solo_eventID_count_title = stringTokenizer.nextToken().trim();
            this.known_solo_eventID_count = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.user_solo_eventID_count_title = stringTokenizer.nextToken().trim();
            this.user_solo_eventID_count = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.commtable_fptr_title = stringTokenizer.nextToken().trim();
            this.commtable_fptr = Long.parseLong(stringTokenizer.nextToken().trim()) * Long.parseLong(stringTokenizer.nextToken().trim()) + Long.parseLong(stringTokenizer.nextToken().trim());
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return false;
        }
        LineID.setCommRank2LineIDxForm(this.max_world_size, this.max_thread_count);
        return true;
    }

    public String getVersionString() {
        return this.version;
    }

    public boolean isVersionMatched() {
        return this.version.equalsIgnoreCase("CLOG-02.44");
    }

    public boolean isVersionCompatible() {
        boolean bl = false;
        for (int i = 0; i < Const.COMPAT_VERSIONS.length && !bl; ++i) {
            String string = Const.COMPAT_VERSIONS[i];
            bl = this.version.equalsIgnoreCase(string);
        }
        return bl;
    }

    public boolean isBigEndian() {
        return this.is_big_endian;
    }

    public boolean isFinalized() {
        return this.is_finalized;
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public int getMaxCommWorldSize() {
        return this.max_world_size;
    }

    public int getMaxThreadCount() {
        return this.max_thread_count;
    }

    public int getKnownEventIDStart() {
        return this.known_eventID_start;
    }

    public int getUserEventIDStart() {
        return this.user_eventID_start;
    }

    public int getKnownSoloEventIDStart() {
        return this.known_solo_eventID_start;
    }

    public int getUserSoloEventIDStart() {
        return this.user_solo_eventID_start;
    }

    public int getKnownStateIDCount() {
        return this.known_stateID_count;
    }

    public int getUserStateIDCount() {
        return this.user_stateID_count;
    }

    public int getKnownSoloEventIDCount() {
        return this.known_solo_eventID_count;
    }

    public int getUserSoloEventIDCount() {
        return this.user_solo_eventID_count;
    }

    public long getCommTableFptr() {
        return this.commtable_fptr;
    }

    public String toString() {
        return this.version + "\n" + this.is_big_endian_title + this.is_big_endian + "\n" + this.is_finalized_title + this.is_finalized + "\n" + this.block_size_title + this.block_size + "\n" + this.num_blocks_title + this.num_blocks + "\n" + this.max_world_size_title + this.max_world_size + "\n" + this.max_thread_count_title + this.max_thread_count + "\n" + this.known_eventID_start_title + this.known_eventID_start + "\n" + this.user_eventID_start_title + this.user_eventID_start + "\n" + this.known_solo_eventID_start_title + this.known_solo_eventID_start + "\n" + this.user_solo_eventID_start_title + this.user_solo_eventID_start + "\n" + this.known_stateID_count_title + this.known_stateID_count + "\n" + this.user_stateID_count_title + this.user_stateID_count + "\n" + this.known_solo_eventID_count_title + this.known_solo_eventID_count + "\n" + this.user_solo_eventID_count_title + this.user_solo_eventID_count + "\n" + this.commtable_fptr_title + this.commtable_fptr + "\n";
    }
}

