/*
 * Decompiled with CFR 0.152.
 */
package old_base.drawable;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import old_base.drawable.Category;
import old_base.drawable.CategoryWeight;
import old_base.drawable.ColorAlpha;
import old_base.drawable.Coord;
import old_base.drawable.CoordPixelXform;
import old_base.drawable.Drawable;
import old_base.drawable.DrawnBox;
import old_base.drawable.DrawnBoxSet;
import old_base.drawable.Primitive;
import old_base.drawable.TimeBoundingBox;
import old_base.io.MixedDataInput;
import old_base.io.MixedDataOutput;
import old_base.topology.Line;
import old_base.topology.PreviewEvent;
import old_base.topology.PreviewState;

public class Shadow
extends Primitive {
    private static final int BYTESIZE = 28;
    private long num_real_objs;
    private CategoryWeight[] twgt_ary;
    private Map map_type2twgt;
    private Map map_type2dobjs;
    private Set set_nestables;
    private List list_childshades;
    private Category selected_subtype;
    private int total_pixel_height;
    private static Insets Empty_Border = new Insets(0, 2, 0, 2);
    private static long Arrow_Log_Base = 10L;
    private static Stroke[] Line_Strokes = new Stroke[10];

    public Shadow() {
        this.num_real_objs = 0L;
        this.twgt_ary = null;
        this.map_type2dobjs = null;
        this.map_type2twgt = null;
        this.set_nestables = null;
        this.list_childshades = null;
        this.selected_subtype = null;
        this.total_pixel_height = 0;
    }

    public Shadow(Shadow shadow) {
        super(shadow);
        this.num_real_objs = shadow.num_real_objs;
        this.twgt_ary = null;
        this.map_type2twgt = new HashMap();
        this.map_type2dobjs = null;
        this.set_nestables = null;
        this.list_childshades = null;
        Iterator iterator = shadow.map_type2twgt.values().iterator();
        while (iterator.hasNext()) {
            CategoryWeight categoryWeight = (CategoryWeight)iterator.next();
            this.map_type2twgt.put(categoryWeight.getCategory(), new CategoryWeight(categoryWeight));
        }
        this.selected_subtype = null;
        this.total_pixel_height = 0;
    }

    public Shadow(Category category, Primitive primitive) {
        super(category, primitive);
        this.num_real_objs = 1L;
        this.twgt_ary = null;
        this.map_type2twgt = null;
        this.map_type2dobjs = new HashMap();
        ArrayList<Primitive> arrayList = new ArrayList<Primitive>();
        arrayList.add(primitive);
        this.map_type2dobjs.put(primitive.getCategory(), arrayList);
        if (category.getTopology().isState()) {
            this.set_nestables = new TreeSet(Drawable.INCRE_STARTTIME_ORDER);
            this.set_nestables.add(primitive);
            this.list_childshades = new ArrayList();
        } else {
            this.set_nestables = null;
            this.list_childshades = null;
        }
        this.selected_subtype = null;
        this.total_pixel_height = 0;
    }

    public void mergeWithPrimitive(Primitive primitive) {
        Coord[] coordArray;
        Coord[] coordArray2 = primitive.getVertices();
        if (coordArray2.length != (coordArray = super.getVertices()).length) {
            String string = "Shadow.mergeWithPrimitive(): ERROR! Incompatible Topology between Shadow and Primitive.";
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < coordArray.length; ++i) {
            coordArray[i].time = Shadow.aveOverAllObjs(coordArray[i].time, this.num_real_objs, coordArray2[i].time, 1L);
        }
        super.affectTimeBounds(primitive);
        ++this.num_real_objs;
        ArrayList<Primitive> arrayList = (ArrayList<Primitive>)this.map_type2dobjs.get(primitive.getCategory());
        if (arrayList == null) {
            arrayList = new ArrayList<Primitive>();
            arrayList.add(primitive);
            this.map_type2dobjs.put(primitive.getCategory(), arrayList);
        } else {
            arrayList.add(primitive);
        }
        if (this.set_nestables != null) {
            this.set_nestables.add(primitive);
        }
    }

    public void mergeWithShadow(Shadow shadow) {
        float f;
        Coord[] coordArray;
        Coord[] coordArray2 = shadow.getVertices();
        if (coordArray2.length != (coordArray = super.getVertices()).length) {
            String string = "Shadow.mergeWithShadow(): ERROR! Incompatible Topology between the 2 Shadows.";
            throw new IllegalArgumentException(string);
        }
        double d = super.getDuration();
        for (int i = 0; i < coordArray.length; ++i) {
            coordArray[i].time = Shadow.aveOverAllObjs(coordArray[i].time, this.num_real_objs, coordArray2[i].time, shadow.num_real_objs);
        }
        super.affectTimeBounds(shadow);
        double d2 = super.getDuration();
        this.num_real_objs += shadow.num_real_objs;
        if (d != d2) {
            f = (float)(d / d2);
            Iterator iterator = this.map_type2twgt.values().iterator();
            while (iterator.hasNext()) {
                CategoryWeight categoryWeight = (CategoryWeight)iterator.next();
                categoryWeight.rescaleAllRatios(f);
            }
        }
        double d3 = shadow.getDuration();
        f = (float)(d3 / d2);
        Iterator iterator = shadow.map_type2twgt.values().iterator();
        while (iterator.hasNext()) {
            CategoryWeight categoryWeight = (CategoryWeight)iterator.next();
            Category category = categoryWeight.getCategory();
            CategoryWeight categoryWeight2 = (CategoryWeight)this.map_type2twgt.get(category);
            if (categoryWeight2 == null) {
                categoryWeight2 = new CategoryWeight(categoryWeight);
                categoryWeight2.rescaleAllRatios(f);
                this.map_type2twgt.put(category, categoryWeight2);
                continue;
            }
            categoryWeight2.addAllRatios(categoryWeight, f);
        }
        if (this.set_nestables != null) {
            this.list_childshades.add(shadow);
        }
    }

    private void setNestingExclusion() {
        Object[] objectArray = this.list_childshades.toArray();
        Stack<Drawable> stack = new Stack<Drawable>();
        Iterator iterator = this.set_nestables.iterator();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            drawable.initExclusion(objectArray);
            while (!stack.empty()) {
                Drawable drawable2 = (Drawable)stack.peek();
                if (drawable2.covers(drawable)) {
                    drawable2.decrementExclusion(drawable.getExclusion());
                    break;
                }
                stack.pop();
            }
            stack.push(drawable);
        }
        stack.clear();
        this.list_childshades.clear();
        this.list_childshades = null;
        this.set_nestables.clear();
        this.set_nestables = null;
    }

    public void initializeMapOfCategoryWeights() {
        if (this.map_type2twgt == null) {
            this.map_type2twgt = new HashMap();
        }
        double d = super.getDuration();
        Iterator iterator = this.map_type2dobjs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Category category = (Category)entry.getKey();
            List list = (List)entry.getValue();
            float f = 0.0f;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Drawable drawable = (Drawable)iterator2.next();
                double d2 = drawable.getDuration() / d;
                f += (float)d2;
            }
            CategoryWeight categoryWeight = new CategoryWeight(category, f, 0.0f);
            this.map_type2twgt.put(category, categoryWeight);
            list = null;
        }
    }

    public void finalizeMapOfCategoryWeights() {
        if (this.set_nestables != null) {
            this.setNestingExclusion();
            double d = super.getDuration();
            Iterator iterator = this.map_type2dobjs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Category category = (Category)entry.getKey();
                List list = (List)entry.getValue();
                float f = 0.0f;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Drawable drawable = (Drawable)iterator2.next();
                    double d2 = drawable.getExclusion() / d;
                    f += (float)d2;
                }
                CategoryWeight categoryWeight = (CategoryWeight)this.map_type2twgt.get(category);
                categoryWeight.addExclusiveRatio(f);
                list = null;
            }
        }
        if (this.map_type2dobjs != null) {
            this.map_type2dobjs.clear();
            this.map_type2dobjs = null;
        }
    }

    private static double aveOverAllObjs(double d, long l, double d2, long l2) {
        return (d * (double)l + d2 * (double)l2) / (double)(l + l2);
    }

    public int getByteSize() {
        if (this.twgt_ary != null) {
            return super.getByteSize() + 28 + 12 * this.twgt_ary.length;
        }
        if (this.map_type2twgt != null) {
            return super.getByteSize() + 28 + 12 * this.map_type2twgt.size();
        }
        return super.getByteSize() + 28 + 12 * this.map_type2dobjs.size();
    }

    public boolean resolveCategory(Map map) {
        boolean bl = super.resolveCategory(map);
        if (this.twgt_ary != null) {
            for (int i = this.twgt_ary.length - 1; i >= 0; --i) {
                bl = bl && this.twgt_ary[i].resolveCategory(map);
            }
        }
        return bl;
    }

    public CategoryWeight[] arrayOfCategoryWeights() {
        return this.twgt_ary;
    }

    public Category getSelectedSubCategory() {
        return this.selected_subtype;
    }

    public void clearSelectedSubCategory() {
        this.selected_subtype = null;
    }

    public void setTotalPixelHeight(int n) {
        this.total_pixel_height = n;
    }

    public int getTotalPixelHeight() {
        return this.total_pixel_height;
    }

    public long getNumOfRealObjects() {
        return this.num_real_objs;
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        super.writeObject(mixedDataOutput);
        TimeBoundingBox.writeObject(this, mixedDataOutput);
        mixedDataOutput.writeLong(this.num_real_objs);
        if (this.map_type2twgt.size() > 0) {
            Object[] objectArray = this.map_type2twgt.values().toArray();
            Arrays.sort(objectArray, CategoryWeight.INCL_RATIO_ORDER);
            int n = objectArray.length;
            mixedDataOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                ((CategoryWeight)objectArray[i]).writeObject(mixedDataOutput);
            }
        } else {
            mixedDataOutput.writeInt(0);
        }
    }

    public Shadow(MixedDataInput mixedDataInput) throws IOException {
        this.readObject(mixedDataInput);
    }

    public void readObject(MixedDataInput mixedDataInput) throws IOException {
        super.readObject(mixedDataInput);
        TimeBoundingBox.readObject(this, mixedDataInput);
        this.num_real_objs = mixedDataInput.readLong();
        int n = mixedDataInput.readInt();
        if (n > 0) {
            this.twgt_ary = new CategoryWeight[n];
            for (int i = 0; i < n; ++i) {
                this.twgt_ary[i] = new CategoryWeight(mixedDataInput);
            }
        } else {
            this.twgt_ary = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" Nrobjs=" + this.num_real_objs);
        CategoryWeight[] categoryWeightArray = null;
        if (this.twgt_ary != null) {
            categoryWeightArray = this.twgt_ary;
        } else if (this.map_type2twgt != null) {
            categoryWeightArray = (CategoryWeight[])this.map_type2twgt.values().toArray();
        }
        if (categoryWeightArray != null) {
            int n = categoryWeightArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\n" + categoryWeightArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static void setStateInsetsDimension(int n, int n2) {
        Empty_Border = new Insets(n2, n, n2, n);
    }

    public int drawState(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet, ColorAlpha colorAlpha) {
        double d = super.getEarliestTime();
        double d2 = super.getLatestTime();
        int n = super.getRowID();
        float f = super.getNestingFactor();
        float f2 = (float)n - f / 2.0f;
        float f3 = f2 + f;
        return PreviewState.draw((Graphics2D)graphics2D, (Color)colorAlpha, (Shadow)this, (Insets)Empty_Border, (CoordPixelXform)coordPixelXform, (DrawnBox)drawnBoxSet.getLastStatePos(n), (double)d, (float)f2, (double)d2, (float)f3);
    }

    public static void setBaseOfLogOfObjectNumToArrowWidth(int n) {
        Arrow_Log_Base = n;
    }

    private static Stroke getArrowStroke(long l) {
        int n;
        for (n = 0; n < Line_Strokes.length && (l /= Arrow_Log_Base) != 0L; ++n) {
        }
        if (n < Line_Strokes.length) {
            return Line_Strokes[n];
        }
        return Line_Strokes[Line_Strokes.length - 1];
    }

    public int drawArrow(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet, ColorAlpha colorAlpha) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = super.getEarliestTime();
        double d2 = super.getLatestTime();
        int n = (Integer)map.get(new Integer(coord.lineID));
        int n2 = (Integer)map.get(new Integer(coord2.lineID));
        Stroke stroke = Shadow.getArrowStroke(this.num_real_objs);
        return Line.draw((Graphics2D)graphics2D, (Color)colorAlpha, (Stroke)stroke, (CoordPixelXform)coordPixelXform, (DrawnBox)drawnBoxSet.getLastArrowPos(n, n2), (double)d, (float)n, (double)d2, (float)n2);
    }

    public int drawEvent(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet, ColorAlpha colorAlpha) {
        Coord coord = this.getStartVertex();
        double d = super.getEarliestTime();
        double d2 = super.getLatestTime();
        double d3 = coord.time;
        int n = (Integer)map.get(new Integer(coord.lineID));
        float f = (float)n - 0.25f;
        float f2 = (float)n - 0.5f;
        float f3 = f2 + 1.0f;
        return PreviewEvent.draw((Graphics2D)graphics2D, (Color)colorAlpha, null, (CoordPixelXform)coordPixelXform, (DrawnBox)drawnBoxSet.getLastEventPos(n), (double)d, (float)f2, (double)d2, (float)f3, (double)d3, (float)f);
    }

    public boolean isPixelInState(CoordPixelXform coordPixelXform, Map map, Point point) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = super.getEarliestTime();
        double d2 = super.getLatestTime();
        int n = super.getRowID();
        float f = super.getNestingFactor();
        float f2 = (float)n - f / 2.0f;
        float f3 = f2 + f;
        this.selected_subtype = PreviewState.containsPixel((Shadow)this, (Insets)Empty_Border, (CoordPixelXform)coordPixelXform, (Point)point, (double)d, (float)f2, (double)d2, (float)f3);
        return this.selected_subtype != null;
    }

    public boolean isPixelOnArrow(CoordPixelXform coordPixelXform, Map map, Point point) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = super.getEarliestTime();
        double d2 = super.getLatestTime();
        float f = ((Integer)map.get(new Integer(coord.lineID))).floatValue();
        float f2 = ((Integer)map.get(new Integer(coord2.lineID))).floatValue();
        return Line.containsPixel((CoordPixelXform)coordPixelXform, (Point)point, (double)d, (float)f, (double)d2, (float)f2);
    }

    public boolean isPixelAtEvent(CoordPixelXform coordPixelXform, Map map, Point point) {
        Coord coord = this.getStartVertex();
        double d = super.getEarliestTime();
        double d2 = super.getLatestTime();
        double d3 = coord.time;
        int n = (Integer)map.get(new Integer(coord.lineID));
        float f = (float)n - 0.25f;
        float f2 = (float)n - 0.5f;
        float f3 = f2 + 1.0f;
        return PreviewEvent.containsPixel((CoordPixelXform)coordPixelXform, (Point)point, (double)d, (float)f2, (double)d2, (float)f3, (double)d3, (float)f);
    }

    public boolean containSearchable() {
        for (int i = this.twgt_ary.length - 1; i >= 0; --i) {
            CategoryWeight categoryWeight = this.twgt_ary[i];
            if (!categoryWeight.getCategory().isVisiblySearchable()) continue;
            return true;
        }
        return false;
    }

    static {
        for (int i = Line_Strokes.length - 1; i >= 0; --i) {
            Shadow.Line_Strokes[i] = new BasicStroke(i + 1);
        }
    }
}

