/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.DataInputStream;
import java.io.IOException;
import logformat.clog2.LineID;

public class RecMsg {
    public static final int RECTYPE = 7;
    private static final int BYTESIZE = 24;
    public Integer etype;
    private int icomm;
    private int rank;
    public int tag;
    public int size;
    private static int pad;

    public int readFromDataStream(DataInputStream dataInputStream) {
        try {
            this.etype = new Integer(dataInputStream.readInt());
            this.icomm = dataInputStream.readInt();
            this.rank = dataInputStream.readInt();
            this.tag = dataInputStream.readInt();
            this.size = dataInputStream.readInt();
            pad = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        return 24;
    }

    public int getProcessLineID() {
        return LineID.computeGlobalProcessID(this.icomm, this.rank);
    }

    public int skipBytesFromDataStream(DataInputStream dataInputStream) {
        try {
            dataInputStream.skipBytes(24);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        return 24;
    }

    private String toEventString() {
        switch (this.etype) {
            case -101: {
                return "send";
            }
            case -102: {
                return "recv";
            }
        }
        return "Unknown(" + this.etype + ")";
    }

    public String toString() {
        return "RecMsg[ etype=" + this.toEventString() + ", icomm=" + this.icomm + ", rank=" + this.rank + ", tag=" + this.tag + ", size=" + this.size + " ]";
    }
}

