//%2006////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2000, 2001, 2002 BMC Software; Hewlett-Packard Development
// Company, L.P.; IBM Corp.; The Open Group; Tivoli Systems.
// Copyright (c) 2003 BMC Software; Hewlett-Packard Development Company, L.P.;
// IBM Corp.; EMC Corporation, The Open Group.
// Copyright (c) 2004 BMC Software; Hewlett-Packard Development Company, L.P.;
// IBM Corp.; EMC Corporation; VERITAS Software Corporation; The Open Group.
// Copyright (c) 2005 Hewlett-Packard Development Company, L.P.; IBM Corp.;
// EMC Corporation; VERITAS Software Corporation; The Open Group.
// Copyright (c) 2006 Hewlett-Packard Development Company, L.P.; IBM Corp.;
// EMC Corporation; Symantec Corporation; The Open Group.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// THE ABOVE COPYRIGHT NOTICE AND THIS PERMISSION NOTICE SHALL BE INCLUDED IN
// ALL COPIES OR SUBSTANTIAL PORTIONS OF THE SOFTWARE. THE SOFTWARE IS PROVIDED
// "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//==============================================================================
//
// Author: Warren Otsuka (warren_otsuka@hp.com) 
//
// Modified By:  Carol Ann Krug Graves, Hewlett-Packard Company
//                   (carolann_graves@hp.com)
//               Roger Kumpf, Hewlett-Packard Company (roger_kumpf@hp.com)
//        
//
//%/////////////////////////////////////////////////////////////////////////////

#include <Pegasus/Common/Config.h>
#include <Pegasus/Common/PegasusAssert.h>
#include <Pegasus/Client/CIMClient.h>

PEGASUS_USING_PEGASUS;
PEGASUS_USING_STD;

const String NAMESPACE = "root/SampleProvider";
const CIMObjectPath INSTANCE1("Sample_InstanceProviderClass.Identifier=1");
const CIMObjectPath INSTANCE2("Sample_InstanceProviderClass.Identifier=2");
const CIMObjectPath INSTANCE3("Sample_InstanceProviderClass.Identifier=3");
const String CLASSNAME = "Sample_InstanceProviderClass";

int main(int argc, char** argv)
{
    try
    {
	CIMClient client;
	client.connectLocal();

	Boolean deepInheritance = true;
	Boolean localOnly = true;
	Boolean includeQualifiers = false;
	Boolean includeClassOrigin = false;
	Array<CIMInstance> cimNInstances = 
	  client.enumerateInstances(NAMESPACE, CLASSNAME, deepInheritance,
				    localOnly, includeQualifiers,
				    includeClassOrigin );

	PEGASUS_TEST_ASSERT(cimNInstances.size() == 3);
	for (Uint32 i = 0; i < cimNInstances.size(); i++)
        {
	    if (!((cimNInstances[i].getPath() == INSTANCE1) ||
	          (cimNInstances[i].getPath() == INSTANCE2) ||
	          (cimNInstances[i].getPath() == INSTANCE3)))
            {
                cerr << "Error: EnumInstances failed" << endl;
                exit(1);
            }
        }
    }
    catch(Exception& e)
    {
	cerr << "Error: " << e.getMessage() << endl;
	exit(1);
    }

    cout << "EnumInstances +++++ passed all tests" << endl;
    return 0;
}
