/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef EDITCOMPONENT_H
#define EDITCOMPONENT_H
#include "editcomponent.h"

class SCompIndex;

class editcomponent : public editcomponentBase
{ 
    Q_OBJECT

public:
    editcomponent( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );
    ~editcomponent();
	int exec();
	void setNote(const QString& text){m_strNote = text;}
	void setName(const QString& text){m_strName = text;}
	void setReference(const QString& text){m_strReference = text;}
	void setOrgName(const QString& text){m_orgName = text;}
	QString note()const{return m_strNote;}
	QString name()const{return m_strName;}
	QString reference()const{return m_strReference;}
	QString orgName()const{return m_orgName;}
	void setBlock(int block){m_block = block;}
	int block()const{return m_block;}
	void setCompIndex(const SCompIndex* pIndex);
	void setNameVertical(bool vert){m_nameVert=vert;}
	void setReferenceVertical(bool vert){m_referenceVert=vert;}
	bool nameVertical(){return m_nameVert;}
	bool referenceVertical(){return m_referenceVert;}

protected  slots:
	void accept();
	void blockChanged(int);

protected:
	void setPinNum(int block);

protected:
	QString m_strNote;
	QString m_strName;
	QString m_strReference;
	QString m_orgName;
	int m_block;
	int m_maxblock;
	bool m_nameVert;
	bool m_referenceVert;
	

	const SCompIndex* m_compInfoIndex;
};

#endif // EDITCOMPONENT_H
