/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "edittag.h"

#include <q3buttongroup.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
//Added by qt3to4:
#include <QHBoxLayout>
#include <QGridLayout>

static const char* const image0_data[] = { 
"51 41 2 1",
". c None",
"# c #000000",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
".....................................#.............",
"....................................#.#............",
"...................................#...#...........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
".........#####################....#.....#..........",
"........#....................#....#.....#..........",
".......#.....................#....#.....#..........",
"......#......................#....#.....#..........",
".......#.....................#....#.....#..........",
"........#....................#....#.....#..........",
".........#####################....#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#######..........",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"..................................................."};

static const char* const image1_data[] = { 
"51 41 2 1",
". c None",
"# c #000000",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
".....................................#.............",
"....................................#.#............",
"...................................#...#...........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
".........##################.......#.....#..........",
"........#..................#......#.....#..........",
".......#....................#.....#.....#..........",
"......#......................#....#.....#..........",
".......#....................#.....#.....#..........",
"........#..................#......#.....#..........",
".........##################.......#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"...................................#...#...........",
"....................................#.#............",
".....................................#.............",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"..................................................."};

static const char* const image2_data[] = { 
"51 41 2 1",
". c None",
"# c #000000",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"..................................#######..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"......########################....#.....#..........",
"......#......................#....#.....#..........",
"......#......................#....#.....#..........",
"......#......................#....#.....#..........",
"......#......................#....#.....#..........",
"......#......................#....#.....#..........",
"......########################....#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#######..........",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"..................................................."};

static const char* const image3_data[] = { 
"51 41 2 1",
". c None",
"# c #000000",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"..................................#######..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"......#####################.......#.....#..........",
"......#....................#......#.....#..........",
"......#.....................#.....#.....#..........",
"......#......................#....#.....#..........",
"......#.....................#.....#.....#..........",
"......#....................#......#.....#..........",
"......#####################.......#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"..................................#.....#..........",
"...................................#...#...........",
"....................................#.#............",
".....................................#.............",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"...................................................",
"..................................................."};


/* 
 *  Constructs a EditTagBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
EditTagBase::EditTagBase( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    QPixmap image0( ( const char** ) image0_data );
    QPixmap image1( ( const char** ) image1_data );
    QPixmap image2( ( const char** ) image2_data );
    QPixmap image3( ( const char** ) image3_data );
    if ( !name )
	setName( "EditTagBase" );
    resize( 278, 204 ); 
    setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, sizePolicy().hasHeightForWidth() ) );
    setProperty( "minimumSize", QSize( 0, 0 ) );
    setProperty( "windowTitle", tr( "Qt-BSch EditTag" ) );
//    setProperty( "caption", tr( "Qt-BSch EditTag" ) );
    setProperty( "sizeGripEnabled", QVariant( FALSE, 0 ) );
    EditTagBaseLayout = new QGridLayout( this ); 
    EditTagBaseLayout->setSpacing( 6 );
    EditTagBaseLayout->setMargin( 11 );

    Layout1 = new QHBoxLayout; 
    Layout1->setSpacing( 6 );
    Layout1->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    buttonOk = new QPushButton( this, "buttonOk" );
    //buttonOk->setProperty( "caption", tr( "" ) );
    buttonOk->setProperty( "text", tr( "&OK" ) );
    buttonOk->setProperty( "autoDefault", QVariant( TRUE, 0 ) );
    buttonOk->setProperty( "default", QVariant( TRUE, 0 ) );
    Layout1->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setProperty( "text", tr( "&Cancel" ) );
    buttonCancel->setProperty( "autoDefault", QVariant( TRUE, 0 ) );
    Layout1->addWidget( buttonCancel );

    EditTagBaseLayout->addLayout( Layout1, 2, 0 );

    ButtonGroup1 = new Q3ButtonGroup( this, "ButtonGroup1" );
    ButtonGroup1->setProperty( "title", tr( "Tag type" ) );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 0 );
    ButtonGroup1->layout()->setMargin( 0 );
    ButtonGroup1Layout = new QGridLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );
    ButtonGroup1Layout->setSpacing( 6 );
    ButtonGroup1Layout->setMargin( 11 );

    RadioButton7 = new QRadioButton( ButtonGroup1, "RadioButton7" );
    RadioButton7->setProperty( "text", tr( "" ) );
//    RadioButton7->setProperty( "pixmap", image0 );
    
    RadioButton7->setIcon(image0);
    RadioButton7->setIconSize(QSize(51, 41));

    ButtonGroup1Layout->addWidget( RadioButton7, 0, 1 );

    RadioButton6 = new QRadioButton( ButtonGroup1, "RadioButton6" );
//    RadioButton6->setProperty( "text", tr( "" ) );
//    RadioButton6->setProperty( "pixmap", image1 );
    RadioButton6->setIcon(image1);
    RadioButton6->setIconSize(QSize(51, 41));

    ButtonGroup1Layout->addWidget( RadioButton6, 1, 0 );

    RadioButton5 = new QRadioButton( ButtonGroup1, "RadioButton5" );
//    RadioButton5->setProperty( "text", tr( "" ) );
//    RadioButton5->setProperty( "pixmap", image2 );
    RadioButton5->setIcon(image2);
    RadioButton5->setIconSize(QSize(51, 41));


    ButtonGroup1Layout->addWidget( RadioButton5, 0, 0 );

    RadioButton8 = new QRadioButton( ButtonGroup1, "RadioButton8" );
//    RadioButton8->setProperty( "text", tr( "" ) );
//    RadioButton8->setProperty( "pixmap", image3 );
    RadioButton8->setIcon(image3);
    RadioButton8->setIconSize(QSize(51, 41));

    ButtonGroup1Layout->addWidget( RadioButton8, 1, 1 );

    EditTagBaseLayout->addWidget( ButtonGroup1, 1, 0 );

    LineEdit2 = new QLineEdit( this, "LineEdit2" );

    EditTagBaseLayout->addWidget( LineEdit2, 0, 0 );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );

    // tab order
    setTabOrder( LineEdit2, RadioButton5 );
    setTabOrder( RadioButton5, RadioButton6 );
    setTabOrder( RadioButton6, RadioButton7 );
    setTabOrder( RadioButton7, RadioButton8 );
    setTabOrder( RadioButton8, buttonOk );
    setTabOrder( buttonOk, buttonCancel );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
EditTagBase::~EditTagBase()
{
    // no need to delete child widgets, Qt does it all for us
}

