/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "selcomp.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <q3listbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
//Added by qt3to4:
#include <QHBoxLayout>
#include <QGridLayout>

/* 
 *  Constructs a selcompBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
selcompBase::selcompBase( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "selcompBase" );
    resize( 457, 273 ); 
    setProperty( "windowTitle", tr( "Qt-BSch Select Component" ) );
//    setProperty( "caption", tr( "Qt-BSch Select Component" ) );
    setProperty( "sizeGripEnabled", QVariant( FALSE, 0 ) );
    selcompBaseLayout = new QGridLayout( this ); 
    selcompBaseLayout->setSpacing( 6 );
    selcompBaseLayout->setMargin( 6 );

    TextLabel1 = new QLabel( this, "TextLabel1" );
    TextLabel1->setProperty( "text", tr( "Library" ) );

    selcompBaseLayout->addWidget( TextLabel1, 0, 0 );

    TextLabel1_2 = new QLabel( this, "TextLabel1_2" );
    TextLabel1_2->setProperty( "maximumSize", QSize( 160, 32767 ) );
    TextLabel1_2->setProperty( "text", tr( "Name" ) );

    selcompBaseLayout->addWidget( TextLabel1_2, 0, 1 );

    ListBoxLibrary = new Q3ListBox( this, "ListBoxLibrary" );
    ListBoxLibrary->insertItem( tr( "New Item" ) );
    ListBoxLibrary->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)7, ListBoxLibrary->sizePolicy().hasHeightForWidth() ) );
    ListBoxLibrary->setProperty( "minimumSize", QSize( 100, 0 ) );
    ListBoxLibrary->setProperty( "maximumSize", QSize( 100, 32767 ) );

    selcompBaseLayout->addMultiCellWidget( ListBoxLibrary, 1, 2, 0, 0 );

    Layout1 = new QHBoxLayout; 
    Layout1->setSpacing( 6 );
    Layout1->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    buttonOk = new QPushButton( this, "buttonOk" );
    //buttonOk->setProperty( "caption", tr( "" ) );
    buttonOk->setProperty( "text", tr( "&OK" ) );
    buttonOk->setProperty( "autoDefault", QVariant( TRUE, 0 ) );
    buttonOk->setProperty( "default", QVariant( TRUE, 0 ) );
    Layout1->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setProperty( "text", tr( "&Cancel" ) );
    buttonCancel->setProperty( "autoDefault", QVariant( TRUE, 0 ) );
    Layout1->addWidget( buttonCancel );

    selcompBaseLayout->addMultiCellLayout( Layout1, 3, 3, 0, 1 );

    ListBoxName = new Q3ListBox( this, "ListBoxName" );
    ListBoxName->insertItem( tr( "New Item" ) );
    ListBoxName->setProperty( "minimumSize", QSize( 150, 0 ) );
    ListBoxName->setProperty( "maximumSize", QSize( 150, 32767 ) );

    selcompBaseLayout->addWidget( ListBoxName, 2, 1 );

    LineEditName = new QLineEdit( this, "LineEditName" );
    LineEditName->setProperty( "minimumSize", QSize( 150, 0 ) );
    LineEditName->setProperty( "maximumSize", QSize( 150, 32767 ) );

    selcompBaseLayout->addWidget( LineEditName, 1, 1 );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( ListBoxLibrary, SIGNAL( selectionChanged() ), this, SLOT( libraryChanged() ) );
    connect( ListBoxName, SIGNAL( selectionChanged(Q3ListBoxItem*) ), this, SLOT( componentChanged() ) );
	connect( LineEditName, SIGNAL( textChanged ( const QString & ) ),this, SLOT( editnameChanged()) );

    // tab order
    setTabOrder( LineEditName, ListBoxLibrary );
    setTabOrder( ListBoxLibrary, ListBoxName );
    setTabOrder( ListBoxName, buttonOk );
    setTabOrder( buttonOk, buttonCancel );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
selcompBase::~selcompBase()
{
    // no need to delete child widgets, Qt does it all for us
}

void selcompBase::libraryChanged()
{
    qWarning( "selcompBase::libraryChanged(): Not implemented yet!" );
}

void selcompBase::componentChanged()
{
    qWarning( "selcompBase::componentChanged(): Not implemented yet!" );
}

void selcompBase::editnameChanged()
{
    qWarning( "selcompBase::editnameChanged(): Not implemented yet!" );
}
