/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/
#include <QtGui>
#include <q3listbox.h>
#include <qpushbutton.h>
#include <q3filedialog.h>
#include <qstringlist.h>

#include "xbsch.h"
#include "setlibimpl.h"


/* 
 *  Constructs a SetLib which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SetLib::SetLib( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : SetLibBase( parent, name, modal, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SetLib::~SetLib()
{
    // no need to delete child widgets, Qt does it all for us
}


void SetLib::setFiles(const QStringList& files)
{
	m_files=QStringList(files);
}

QStringList SetLib::selectedFiles()
{
	return m_files;
}


int SetLib::exec()
{
	ListBox1->clear();
	for(QStringList::Iterator it = m_files.begin(); it != m_files.end(); ++it ){
		if(ListBox1->count() >= MAX_LIB){
			break;
		}
		ListBox1->insertItem(*it);
	}
	if(ListBox1->count() > 0){
		ListBox1->setSelected (0,true);
	}
	setButtonEnable();
	return SetLibBase::exec();
}

void SetLib::accept()
{
	m_files.clear();
	int count=ListBox1->count();
	if(count>MAX_LIB) count=MAX_LIB;
	for(int n=0; n<count; n++){
		m_files.append(ListBox1->text(n));
	}
	SetLibBase::accept();
}

void SetLib::OnAddButton()
{
	if(ListBox1->count() < MAX_LIB){

		QString types("Qt-BSch Library(*.lb3);;"
					  "Qt-BSch Schematic(*.ce3)");
		QStringList sl = QFileDialog::getOpenFileNames( this,QString::null,QString::null,types);
		//QStringList sl=Q3FileDialog::getOpenFileNames(types);
		if(!sl.isEmpty()){
			for ( QStringList::Iterator it = sl.begin(); it != sl.end(); ++it ){
				if(ListBox1->count() >= MAX_LIB){
					break;
				}
				ListBox1->insertItem(*it);
			}
		}
	}
	//ҤȤĤǤ饤֥̾åȤƤ...
	if(ListBox1->count() > 0){
		ListBox1->setSelected (0,true);
	}
	setButtonEnable();

}

void SetLib::OnDownButton()
{
	int count = ListBox1->count();
	int index = ListBox1->currentItem();

	if(count>0 && index<(count-1)){
		QString str = ListBox1->text(index);
		ListBox1->removeItem(index);
		ListBox1->insertItem(str,index+1);
		ListBox1->setSelected (index+1,true);
	}
	setButtonEnable();
}

void SetLib::OnUpButton()
{
	int count = ListBox1->count();
	int index = ListBox1->currentItem();

	if(count>0 && index>=1){
		QString str = ListBox1->text(index);
		ListBox1->removeItem(index);
		ListBox1->insertItem(str,index-1);
		ListBox1->setSelected (index-1,true);
	}
	setButtonEnable();
}

void SetLib::itemChanged()
{
	setButtonEnable();
}

void SetLib::OnRemoveButton()
{
	if(ListBox1->count() == 0){
		buttonRemove->setEnabled(false);
		return;
	}
	int index = ListBox1->currentItem(); 
	if(index != -1){
		ListBox1->removeItem(index);
	}
	setButtonEnable();
}

void SetLib::setButtonEnable()
{
	int count = ListBox1->count();
	int index = ListBox1->currentItem();

	buttonAdd->setEnabled(count<MAX_LIB);
	buttonRemove->setEnabled(count>0 && index!=-1);
	buttonUp->setEnabled(count>0 && index>=1);
	buttonDown->setEnabled(count>0 && index<(count-1));
}
