/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// Copyright (C) 2002 H.Okada(suigyodo) All rights reserved.
/****************************************************************************
** XBSchǥ饹
****************************************************************************/
#ifndef XBSCHOBJ_H
#define XBSCHOBJ_H

#include "xbsch.h"
//#include <SPoint.h>
//#include <SRect.h>
#include "coord.h"
#include "ce3io.h"

class SXBSchDoc;

/*
#define		NOT_SELECT	0
#define		SELECT_P1	1
#define		SELECT_P2	2
#define		SELECT_ALL	3

#define		OUTCODE_LEFT		0x0001
#define		OUTCODE_UPPER		0x0002
#define		OUTCODE_RIGHT		0x0004
#define		OUTCODE_LOWER		0x0008
*/

enum BSCH_TOOL_MODE
{
	TOOL_SELECTOR,
	TOOL_DRAG,
	TOOL_COMPONENT,
	TOOL_BUS,
	TOOL_WIRE,
	TOOL_DASH,
	TOOL_JUNCTION,
	TOOL_BENTRY,
	TOOL_ENTRY,
	TOOL_TAG,
	TOOL_LABEL,
	TOOL_COMMENT
};

enum ON_OBJECT
{
	ON_OBJ		=0x10000,
	ON_NAME		=0x20000,
	ON_NUM		=0x40000
};

class SXBSchObj
{
public:
	enum BSCHOBJ_ID
	{
		ID_JUNCTION		=0,
		ID_ENTRY		=1,
		ID_BENTRY		=2,
		ID_BUS			=3,
		ID_WIRE			=4,
		ID_DASH			=5,
		ID_LABEL		=6,
		ID_TAG			=7,
		ID_COMPONENT	=8,
		ID_SHEETINFO	=9,
		ID_COMMENT		=10,
		ID_DELETEOBJ	=254,
		ID_ENDOFDATA	=255
	};

	enum SELECTION
	{
		NOT_SELECTED	=0,
		SELECT_P1		=1,
		SELECT_P2		=2,
		SELECT_ALL		=3
	};

	enum OUTCODE
	{
		OUTCODE_CENTER	=	0x0000,
		OUTCODE_LEFT	=	0x0001,
		OUTCODE_UPPER	=	0x0002,
		OUTCODE_RIGHT	=	0x0004,
		OUTCODE_LOWER	=	0x0008
	};

protected:
	//֤Ȥֹ
	int m_PlaceNum;
	//ȥ֥ȤؤΥݥ
	//	ID_DELETEOBJ Ǥϡξõ֥Ȥ̵ƤȤоݥ֥Ȥؤ
	//  ʳΥ֥ȤǤϡõ֥ȤؤNULLΤȤϡΥ֥Ȥͭ
	//  뤳Ȥɽ
	SXBSchObj* m_pRefObj;
	//֥쥤䡼
	int m_Layer;
	//֥Ȥκɸ
	SPoint m_p1;
	SPoint m_p2;
	//
	unsigned m_Selection;

	bool isValidLayer(int n){return (n>=0 && n<8);}

public:
	//󥹥ȥ饯
	SXBSchObj();
	//ǥȥ饯
	virtual ~SXBSchObj(){};

//	virtual bool readStream(SCsvIStream* ,const SPoint* ){return false;}
//	virtual bool writeStream(SCsvOStream* ,const SPoint* ){return false;}

	virtual bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc* ){return false;}
//	virtual bool readCe3(SReadCE3&,const SPoint* ){return false;}
	virtual bool writeCe3(SWriteCE3& ,const SPoint* ){return false;}

	//IDμ
	virtual unsigned id()=0;
	//֤Ȥֹ
	void setPlaceNum(int n){m_PlaceNum = n;}
	//֤Ȥֹμ
	int placeNum(){return m_PlaceNum;}
	//ȥ֥ȤؤΥݥ󥿤
	void setRefObj(SXBSchObj* pObj){m_pRefObj = pObj;}
	//ȥ֥ȤؤΥݥ󥿤
	SXBSchObj* refObj(){return m_pRefObj;}
	//쥤䡼
	void setLayer(int n){m_Layer=n;}
	//쥤䡼μ
	int layer(){return m_Layer;}
	//ɸ
	virtual void setX1(int x1){m_p1.setX(x1);}
	virtual void setY1(int y1){m_p1.setY(y1);}
	virtual void setX2(int x2){m_p2.setX(x2);}
	virtual void setY2(int y2){m_p2.setY(y2);}
	virtual void setP1(const SPoint& p){m_p1 = p;}
	virtual void setP2(const SPoint& p){m_p2 = p;}
	//ɸμ
	int x1(){return m_p1.x();}
	int y1(){return m_p1.y();}
	virtual int x2(){return m_p2.x();}
	virtual int y2(){return m_p2.y();}
	SPoint p1(){return m_p1;}
	virtual SPoint p2(){return m_p2;}
	virtual SPoint snapPoint(){return m_p1;}
	//֤μ
	unsigned selection(){return m_Selection;}
public:
	//ʣԤ
	virtual SXBSchObj* duplicate(){return NULL;}
	//֤ư
	virtual void move(int offsetx,int offsety);
	//XɸꤷƺȿžԤ
	virtual void mirrorH(int x);
	//ȿžԤ
	virtual void mirrorH();
	//XY濴ɸꤷơžԤ
	virtual void rotate(const SPoint& p);
	//žԤ
	virtual void rotate();
	//ꤷ٤֤
	virtual int qSelectWeight(const SPoint&){return 0;}
	//ե饰򥻥åȤ
	virtual void setSelection(unsigned sel);
	//
	virtual void resetSelection();
	//ϰϤꤷԤ
	virtual unsigned testSelection(const SRect& ){return 0;}
	//ϰϤ򤷤ƥɥåԤ
	virtual unsigned testSelectionForDrag(const SRect& ){return 0;}
	//褬ɬפɤ֤
	virtual bool qRedraw(const SRect& ){return 0;}
	//ԥ֤
	virtual int pinCount()const {return 0;}
	//nܤΥԥΰ֤롣
	virtual SPoint pinPosition(int) const {return SPoint(-1,-1);}
	virtual SRect area(){return SRect(-1,-1,0,0);}
	virtual SRect rotateRect(){return SRect(-1,-1,0,0);}
	//ͭʥ֥Ȥʤtrue֤ʸΤʤƥȡĹΤʤʬͭǤϤʤ
	virtual bool qValid(){return true;}
	//ȥӥ塼Ȥѹǽʾtrue֤
	virtual bool canAttribute() {return false;}
public:
	//prcArea⳰ɤ֤
	static unsigned SetOutCode(const SPoint& p,const SRect& rcArea);
	//ȶνŤʤ򡢽Ť߾դ֤
	static int PointAndRectMag(const SPoint& p,const SRect& rcArea);
};

#endif
