=begin

= NAME

rast_xmlrpc_server_abyss - a Rast database server for XML-RPC.

= SYNOPSIS

rast_xmlrpc_server_abyss [options] Rast-database

= DESCRIPTION

Rast is a full-text search system.  rast_xmlrpc_server_abyss gives
remote access to Rast database.

= OPTIONS

: --read-only

  Opens Rast database in read-only mode (default).  So, modifying Rast database
  is not permitted.

: --read-write

  Opens Rast database in read-write mode.

: --port port-number

  Specifies the port on which the server listens for connections (default 9999).

: --pid-file pid-file

  Specifies the file which contains the process ID of the rast_xmlrpc_server_abyss.

: --log-file log-file

  Specifies the access log filename.  This file is similar to Apache's access
  log.

= EXAMPLES

Running a Rast XML-RPC server (simple case).

  $ rast_xmlrpc_server_abyss /some/where/to/rast-database

Running a Rast XML-RPC server which opens rast-database in read-write mode.  The
server uses 8080 port, writes the process ID to /var/run/rast.pid and writes the
access log to /var/log/rast.log.

  $ rast_xmlrpc_server_abyss --read-write --port 8080 \
      --pid-file /var/run/rast.pid \
      --log-file /var/log/rast.log /some/where/to/rast-database

=end
