/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef RESULT_H
#define RESULT_H

/**
 * @file result.h result
 */

#include <apr_ring.h>

#include "rast/property.h"
#include "rast/macros.h"

RAST_EXTERN_C_BEGIN

typedef struct rast_term_t {
    const char *term;
    int doc_count;
    APR_RING_ENTRY(rast_term_t) link;
} rast_term_t;

APR_RING_HEAD(rast_term_ring_t, rast_term_t);
typedef struct rast_term_ring_t rast_term_ring_t;

typedef struct rast_term_frequency_t {
    int count;
    rast_pos_t pos;
    APR_RING_ENTRY(rast_term_frequency_t) link;
} rast_term_frequency_t;

APR_RING_HEAD(rast_term_frequency_ring_t, rast_term_frequency_t);
typedef struct rast_term_frequency_ring_t rast_term_frequency_ring_t;

typedef struct rast_candidate_t {
    rast_doc_id_t doc_id;
    rast_term_frequency_ring_t terms;
    APR_RING_ENTRY(rast_candidate_t) link;
} rast_candidate_t;

APR_RING_HEAD(rast_candidate_ring_t, rast_candidate_t);
typedef struct rast_candidate_ring_t rast_candidate_ring_t;

typedef struct rast_query_result_t {
    rast_term_ring_t terms;
    rast_candidate_ring_t candidates;
} rast_query_result_t;

/**
 * @defgroup result result
 * @{
 */

/** A structure that represents a term in a query */
typedef struct {
    /** The term */
    char *term;
    /** The number of documents that contains the term */
    int doc_count;
} rast_result_term_t;

#if 0
/* todo: for multiple search word summary position */
typedef struct {
    int term_no;
    rast_pos_t pos;
} rast_term_pos_t;
#endif

/** A structure that represents a result item */
typedef struct {
    /** The document ID */
    rast_doc_id_t doc_id;
    /** The database index */
    int db_index;
    /** The score of the document */
    int score;
    /** The summary of the document */
    char *summary;
    /** The length of summary in bytes */
    int summary_nbytes;
#if 0
    /* todo: for multiple search word summary position */
    rast_term_pos_t *term_positions;
    int num_term_positions;
#endif
    /** The properties of the document */
    rast_value_t *properties;
} rast_result_item_t;

/** A structure that represents a search result */
typedef struct {
    /** The number of indices in search database */
    int num_indices;
    /** The number of documents in search database */
    int num_docs;
    /** The number of documents that hit to the query */
    int hit_count;
    /** The terms in the query */
    rast_result_term_t *terms;
    /** The number of terms in the query */
    int num_terms;
    /** The items in the result */
    rast_result_item_t **items;
    /** The number of the items in the result */
    int num_items;
} rast_result_t;

/** @} */

RAST_EXTERN_C_END

#endif

/* vim: set filetype=c sw=4 expandtab : */
