dnl AM_PATH_XMLRPC([MAJOR], [MINOR], [TEENY])
dnl Adds support for XMLRPC
AC_DEFUN([AM_PATH_XMLRPC],
[
  rast_lib_xmlrpc_major="$1"
  rast_lib_xmlrpc_minor="$2"
  rast_lib_xmlrpc_patch="$3"
  rast_lib_xmlrpc_version="$1.$2.$3"

  AC_ARG_WITH(xmlrpc-c-config,
  AC_HELP_STRING([--with-xmlrpc-c-config=PATH],[path to xmlrpc-c-config]),
  [
      AC_MSG_RESULT([using $withval for xmlrpc-c-config])
      XMLRPC_CONFIG="$withval"
  ], [
      AC_PATH_PROG(XMLRPC_CONFIG, xmlrpc-c-config, no)
  ])
  HAVE_XMLRPC="no"
  if test "$XMLRPC_CONFIG" != "no"; then
    AC_MSG_CHECKING([XMLRPC version])    
    XMLRPC_VERSION="`$XMLRPC_CONFIG --version`"
    if test $? -eq 0; then
      changequote(<<, >>)
      XMLRPC_MAJOR=`expr "$XMLRPC_VERSION" : '\(.*\)\..*\..*'`
      XMLRPC_MINOR=`expr "$XMLRPC_VERSION" : '.*\.\(.*\)\..*'`
      XMLRPC_PATCH=`expr "$XMLRPC_VERSION" : '.*\..*\.\(.*\)'`
      changequote([, ])
      if expr "$XMLRPC_MAJOR" '>' "$rast_lib_xmlrpc_major" > /dev/null ||
         ( expr "$XMLRPC_MAJOR" '=' "$rast_lib_xmlrpc_major" > /dev/null &&
           ( expr "$XMLRPC_MINOR" '>' "$rast_lib_xmlrpc_minor" > /dev/null ||
             ( expr "$XMLRPC_MINOR" '=' "$rast_lib_xmlrpc_minor" > /dev/null &&
               expr "$XMLRPC_PATCH" '>=' "$rast_lib_xmlrpc_patch" > /dev/null ) ) ); then
        HAVE_XMLRPC="yes"
        AC_MSG_RESULT([$XMLRPC_VERSION])

        XMLRPC_ABYSS_SERVER_CFLAGS="`$XMLRPC_CONFIG abyss-server --cflags`"
        XMLRPC_ABYSS_SERVER_LIBS="`$XMLRPC_CONFIG abyss-server --libs`"
        XMLRPC_ABYSS_SERVER_LDADD="`$XMLRPC_CONFIG abyss-server --ldadd`"
        XMLRPC_ABYSS_SERVER_LDFLAGS="`$XMLRPC_CONFIG abyss-server --ldflags`"

        AC_SUBST(XMLRPC_ABYSS_SERVER_CFLAGS)
        AC_SUBST(XMLRPC_ABYSS_SERVER_LIBS)
        AC_SUBST(XMLRPC_ABYSS_SERVER_LDADD)
        AC_SUBST(XMLRPC_ABYSS_SERVER_LDFLAGS)

        XMLRPC_CGI_SERVER_CFLAGS="`$XMLRPC_CONFIG cgi-server --cflags`"
        XMLRPC_CGI_SERVER_LIBS="`$XMLRPC_CONFIG cgi-server --libs`"
        XMLRPC_CGI_SERVER_LDADD="`$XMLRPC_CONFIG cgi-server --ldadd`"
        XMLRPC_CGI_SERVER_LDFLAGS="`$XMLRPC_CONFIG cgi-server --ldflags`"

        AC_SUBST(XMLRPC_CGI_SERVER_CFLAGS)
        AC_SUBST(XMLRPC_CGI_SERVER_LIBS)
        AC_SUBST(XMLRPC_CGI_SERVER_LDADD)
        AC_SUBST(XMLRPC_CGI_SERVER_LDFLAGS)

        XMLRPC_LIBWWW_CLIENT_CFLAGS="`$XMLRPC_CONFIG libwww-client --cflags`"
        XMLRPC_LIBWWW_CLIENT_LIBS="`$XMLRPC_CONFIG libwww-client --libs`"
        XMLRPC_LIBWWW_CLIENT_LDADD="`$XMLRPC_CONFIG libwww-client --ldadd`"
        XMLRPC_LIBWWW_CLIENT_LDFLAGS="`$XMLRPC_CONFIG libwww-client --ldflags`"

        AC_SUBST(XMLRPC_LIBWWW_CLIENT_CFLAGS)
        AC_SUBST(XMLRPC_LIBWWW_CLIENT_LIBS)
        AC_SUBST(XMLRPC_LIBWWW_CLIENT_LDADD)
        AC_SUBST(XMLRPC_LIBWWW_CLIENT_LDFLAGS)
      else
        AC_MSG_WARN([$XMLRPC_VERSION is too old; $rast_lib_xmlrpc_version is required])
      fi
    else
      AC_MSG_WARN([xmlrpc-c-config --version failed])
    fi
  fi
  AC_SUBST(HAVE_XMLRPC)
])
