/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#include <stdlib.h>

#include "rast/config.h"
#include "rast/pack.h"

int
rast_pack_number_length(int n)
{
    int len = 0;

    if (n == 0) {
        return 1;
    }
    while (n > 0) {
        n = n / 0x80;
        len++;
    }
    return len;
}

int
rast_pack_number(char *s, int n)
{
    char *p = s;
    div_t d;

    if (n == 0) {
        *p = 0;
        return 1;
    }
    while (n > 0) {
        d = div(n, 0x80);
        n = d.quot;
        if (n > 0) {
            *p = d.rem | 0x80;
        }
        else {
            *p = d.rem;
        }
        p++;
    }
    return p - s;
}

int
rast_unpack_number(const char *s, int len, int *np)
{
    const char *p = s, *pend = s + len;
    int base = 1, n = 0;

    while (p < pend) {
        if (*p & 0x80) {
            n += base * (*p & 0x7F);
            base *= 0x80;
            p++;
        }
        else {
            n += *p * base;
            p++;
            break;
        }
    }
    *np = n;
    return p - s;
}

/* vim: set filetype=c sw=4 expandtab : */
