/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include <xmlrpc.h>
#include <xmlrpc_cgi.h>

#include <apr_getopt.h>
#include <apr_file_io.h>
#include <apr_strings.h>

#include "rast/rast.h"
#include "rast/merger.h"
#include "rast/xmlrpc_server.h"

rast_error_t *
xmlrpc_server_cgi_initialize(xmlrpc_server_t *server)
{
    apr_pool_t *pool;
    rast_error_t *error;
    int flags;
    const char *db_name, *env_flags, *env_sync_threshold_chars;
    rast_db_t *db;
    rast_db_open_option_t *open_options;

    apr_initialize();
    atexit(apr_terminate);
    error = rast_initialize();
    if (error != RAST_OK) {
        return error;
    }
    atexit(rast_finalize);

    apr_pool_create_ex(&pool, NULL, NULL, NULL);
    server->pool = pool;

    db_name = getenv("RAST_CGI_DB_NAME");
    if (db_name == NULL) {
        return rast_error(RAST_ERROR_INVALID_ARGUMENT, "");
    }

    env_flags = getenv("RAST_CGI_FLAGS");
    if (env_flags != NULL && apr_strnatcasecmp(env_flags, "read-write") == 0) {
        flags = RAST_DB_RDWR;
    }
    else {
        flags = RAST_DB_RDONLY;
    }

    open_options = rast_db_open_option_create(server->pool);
    env_sync_threshold_chars = getenv("RAST_CGI_SYNC_THRESHOLD_CHARS");
    if (env_sync_threshold_chars != NULL) {
        open_options->sync_threshold_chars = atoi(env_sync_threshold_chars);
    }

    error = rast_db_open(&db, db_name, flags, open_options, server->pool);
    if (error != RAST_OK) {
        return error;
    }
    server->db = db;

    return RAST_OK;
}

int
main(int argc, const char **argv)
{
    xmlrpc_server_t server;
    rast_error_t *error;

    error = xmlrpc_server_cgi_initialize(&server);
    if (error != RAST_OK) {
        fprintf(stderr, "%s\n", error->message);
        exit(1);
    }

    xmlrpc_cgi_init(XMLRPC_CGI_NO_FLAGS);
    xmlrpc_cgi_add_method_w_doc("rast.register",
                                &xmlrpc_server_register,
                                (void *) &server, "S:S",
                                "register document to database.");
    xmlrpc_cgi_add_method_w_doc("rast.search",
                                &xmlrpc_server_search,
                                (void *) &server, "S:S",
                                "search document from database.");
    xmlrpc_cgi_add_method_w_doc("rast.delete",
                                &xmlrpc_server_delete,
                                (void *) &server, "S:S",
                                "delete document from database.");
    xmlrpc_cgi_add_method_w_doc("rast.update",
                                &xmlrpc_server_update,
                                (void *) &server, "S:S",
                                "update document at database.");
    xmlrpc_cgi_add_method_w_doc("rast.get_text",
                                &xmlrpc_server_get_text,
                                (void *) &server, "S:S",
                                "get text from database.");
    xmlrpc_cgi_add_method_w_doc("rast.encoding",
                                &xmlrpc_server_encoding,
                                (void *) &server, "S",
                                "get database encoding.");
    xmlrpc_cgi_add_method_w_doc("rast.properties",
                                &xmlrpc_server_properties,
                                (void *) &server, "A",
                                "get propertie's definitions from database.");
    xmlrpc_cgi_process_call();
    xmlrpc_cgi_cleanup();

    return 0;
}
