# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"
require "tempfile"
require "zip/zip"

require "rast"
require "rast/filter"

module Rast
  module Filter
    load_mime_filter("zip.rb")

    class ApplicationZipTest < Test::Unit::TestCase
      def test_invoke
        invoke_test_simple
      end

      def invoke_test_simple
        filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new
        filter_module = ApplicationZip.new
        file = Tempfile.new("zip")
        file.close(false)
        begin
          zip_filename = file.path
          Zip::ZipOutputStream.open(zip_filename) do |zos|
            zos.put_next_entry("weather-ascii.txt")
            zos.write("It is fine.")
            zos.put_next_entry("weather-utf8.txt")
            zos.write("本日は晴天なり")
          end
          File.open(zip_filename) do |f|
            brigade.insert_tail(FileBucket.new(f))
            brigade.insert_tail(EOSBucket.new)
            filter_module.invoke(filter, brigade, "application/x-zip")
          end
        ensure
          file.close(true)
        end

        bodies = []
        buf = ""
        for i in 0 .. filter.passed.length - 1
          filter.passed[i].brigade.each do |bucket|
            if bucket.eos?
              bodies.push(buf)
              buf = ""
              next
            end

            buf.concat(bucket.read)
          end
        end
        assert_equal("It is fine.", bodies[0])
        assert_equal("本日は晴天なり", bodies[1])
        assert_equal(nil, filter.passed[0].mime_type)
        assert_equal("weather-ascii.txt", filter.passed[0].filename)
        assert_equal(nil, filter.passed[1].mime_type)
        assert_equal("weather-utf8.txt", filter.passed[1].filename)
        assert_equal(2, filter.passed.length)
        assert_equal(0, filter.properties.length)
      end
    end
  end
end
