# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "tmpdir"
require "fileutils"

module TestUtility
  module_function

  def mkdtemp(prefix, mode = 0700)
    retry_count = 0
    begin
      dir = File.join(Dir.tmpdir, 
                      "#{prefix}-#{$$}.#{rand(10000)}")
      Dir.mkdir(dir, mode)
      return dir
    rescue Errno::EEXIST
      if retry_count < 3
        retry_count += 1
        retry
      else
        raise "can't create #{dir}"
      end
    end
  end

  def rm_rf(filename)
    count = 0
    begin
      FileUtils.rm_rf(filename)
    rescue Errno::ENOTEMPTY
      if count >= 3
        raise
      end
      count += 1
      retry
    end
  end

  def protect_env(set_envs)
    save_envs = {}
    begin
      set_envs.each do |key, value|
        save_envs[key] = ENV[key]
        ENV[key] = value
      end
      yield
    ensure
      save_envs.each do |key, value|
        ENV[key] = value
      end
    end
  end
end
